#' An example of long-format multistate data 
#'
#' An RData object containing disease progression
#' data for a sample of 576 patients with myelodysplastic
#' syndromes (MDS), as an example of long-format 
#' multistate data.
#' 
#' @format A data frame.
"mstate_data"

#' A simulated event-history data set
#'
#' A data set generated by simulation from an 
#' illness-death Cox model. This is an object
#' of double class 'data.frame' and 'msdata', whose
#' 'trans' attribute is a transition matrix  
#' (\code{attr(mstate_data_sample,"trans")}).
#'
#' @format A data frame with 649 rows and 18 variables
#'  (250 patients):
#' \describe{
#'   \item{id}{patient identification number}
#'   \item{from}{state in which the patient is}
#'   \item{to}{state to which the patient is at risk of going to}
#'   \item{trans}{transition ID number}
#'   \item{Tstart}{when the risk of the transition started}
#'   \item{Tstop}{the time at which the risk of the
#'    transition ended or the last follow-up time (whichever 
#'    happened first)}
#'   \item{time}{Tstop-Tstart}
#'   \item{status}{did the transition occur at Tstop?}
#'   \item{Cov1,Cov2,Cov3,Cov4,Cov5,Cov6,Cov7,Cov8,Cov9,Cov10}{covariates}
#' }
"mstate_data_sample"

#' Example of an empirical Bayes model fit 
#' 
#' An RData object containing the model fit 
#' obtained by running \code{CoxRFX} on the
#' data set \code{mstate_data_sample} (included 
#' in the present package).
#' 
#'
#' @format An object of class 
#' \code{c(coxrfx,coxph.penal,coxph)}, which is 
#' essentially a coxph object with a few 
#' extra fields [the inputs $groups, $Z,
#' and $surv, and the hyperparameters 
#' $sigma2 (variances) and $mu (means)]. 
#'  
#' @seealso \code{\link{mstate_data_sample}}; 
#' \code{\link{CoxRFX}}.
"coxrfx_object_sample"

#' Estimated cumulative hazard rates under 
#' an empirical Bayes Cox model (example)
#'
#' An RData object containing estimated
#' cumulative hazards,
#' obtained by running \code{msfit_generic} on the
#' object \code{coxrfx_object_sample} (also included 
#' in the present package).
#' 
#'
#' @format An object of class 
#' \code{c(msfit,coxrfx)}. See \code{\link{msfit_generic}} 
#' and \code{\link[mstate:msfit]{mstate::msfit}} for details. 
#'  
#' @seealso \code{\link{coxrfx_object_sample}}.
"msfit_object_sample"

