% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmave.R
\name{lmave}
\alias{lmave}
\title{Build multiple lm models and average them}
\usage{
lmave(formula, data, k, method = "boot", seed = 5, weights = NULL, ...)
}
\arguments{
\item{formula}{The formula to be passed to lm}

\item{data}{The data to be used}

\item{k}{The number of models or data partitions desired}

\item{method}{Whether to split data by folds ("fold") or by bootstrapping ("boot")}

\item{seed}{Seed for reproducibility (only needed if method is "boot")}

\item{weights}{Optional vector of weights to be passed to the fitting process}

\item{...}{Additional arguments to be passed to the 'lm' function}
}
\value{
an lm object
}
\description{
Builds k lm models on k partitions of the data and averages their coefficients to get create one model. 
Each partition excludes k/nrow(data) observations.
}
\details{
In some cases--especially in some time series modeling (see ecmave function)--rather than building one model on the entire dataset, it may be preferable to build multiple models on subsets 
of the data and average them. The lmave function splits the data into k partitions, builds k models, each on the data without one of the partitions, and then averages the coefficients of these 
models to get a final model. This is similar to averaging multiple tree regression models in algorithms like random forest.
}
\examples{
#Build linear models to predict Wilshire 5000 index based on corporate profits, 
#Federal Reserve funds rate, and unemployment rate
data(Wilshire)

#Build one model on the entire dataset
modelall <- lm(Wilshire5000 ~ ., data = Wilshire)

#Build a five fold averaged linear model on the entire dataset
modelave <- lmave('Wilshire5000 ~ .', data = Wilshire, k = 5) 

}
\references{
Jung, Y. & Hu, J. (2016). "A K-fold Averaging Cross-validation Procedure". https://www.ncbi.nlm.nih.gov/pmc/articles/PMC5019184/
}
\seealso{
\code{lm}
}
