% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div.r
\name{gower}
\alias{gower}
\title{Gower}
\usage{
gower(counts, weighted = TRUE, pairs = NULL, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{weighted}{If \code{TRUE}, the algorithm takes relative abundances into
account. If \code{FALSE}, only presence/absence is considered.}

\item{pairs}{Which combinations of samples should distances be
calculated for? The default value (\code{NULL}) calculates all-vs-all.
Provide a numeric or logical vector specifying positions in the
distance matrix to calculate. See examples.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A \code{dist} object.
}
\description{
Gower beta diversity metric.
}
\section{Calculation}{


Each row (OTU) of \code{counts} is rescaled to the range 0-1. In cases where a
row is all the same value, those values are replaced with \code{0}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{counts                 scaled recounts
     A B C  D                 A   B   C D  
OTU1 0 0 0  0    ->    OTU1 0.0 0.0 0.0 0
OTU2 0 8 9 10    ->    OTU2 0.0 0.8 0.9 1
OTU3 5 5 5  5    ->    OTU3 0.0 0.0 0.0 0
OTU4 2 0 0  0    ->    OTU4 1.0 0.0 0.0 0
OTU5 4 6 4  1    ->    OTU5 0.6 1.0 0.6 0
}\if{html}{\out{</div>}}

In the formulas below, \code{x} and \code{y} are two columns (samples) from the scaled
counts. \code{n} is the number of rows (OTUs) in \code{counts}.

\deqn{D = \displaystyle \frac{1}{n}\sum_{i = 1}^{n} |x_i - y_i|}

\if{html}{\out{<div class="sourceCode">}}\preformatted{  x <- c(0, 0, 0, 1, 0.6)
  y <- c(0, 0.8, 0, 0, 1)
  sum(abs(x-y)) / length(x)  
  #>  0.44
}\if{html}{\out{</div>}}
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Gower weighted distance matrix
    gower(ex_counts)
    
    # Gower unweighted distance matrix
    gower(ex_counts, weighted = FALSE)
    
    # Only calculate distances for A vs all.
    gower(ex_counts, pairs = 1:3)
    
}
\references{
Gower JC 1971.
A general coefficient of similarity and some of its properties.
Biometrics. 27(4).
\doi{10.2307/2528823}

Gower JC, Legendre P 1986.
Metric and Euclidean Properties of Dissimilarity Coefficients.
Journal of Classification. 3.
\doi{10.1007/BF01896809}
}
\seealso{
Other beta_diversity: 
\code{\link{bray_curtis}()},
\code{\link{canberra}()},
\code{\link{euclidean}()},
\code{\link{generalized_unifrac}()},
\code{\link{jaccard}()},
\code{\link{kulczynski}()},
\code{\link{manhattan}()},
\code{\link{unweighted_unifrac}()},
\code{\link{variance_adjusted_unifrac}()},
\code{\link{weighted_normalized_unifrac}()},
\code{\link{weighted_unifrac}()}
}
\concept{beta_diversity}
