% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDR_data.R
\docType{data}
\name{EDR_data}
\alias{EDR_data}
\title{Ecological Dynamic Regime data}
\format{
List of three nested sublists (\code{"EDR1"}, \code{"EDR2"}, and \code{"EDR3"}), each
associated with one EDR, including the following elements:
\itemize{
\item \code{abundance}: Data table with 15 columns and one row for each community state:
\itemize{
\item \code{EDR}: Integer indicating the identifier of the EDR.
\item \code{traj}: Integer containing the identifier of the trajectory for each
artificial community in the corresponding EDR. Each trajectory represents
a different sampling unit.
\item \code{state}: Integer indicating the observations or states of each community.
The sequence of states of a given community forms a trajectory.
\item \verb{sp1, ..., sp12}: Vectors containing species abundances for each community
state.
}
\item \code{state_dissim}: Object of class \code{dist} containing Bray-Curtis dissimilarities
between every pair of states in \code{abundance} (see Details).
\item \code{segment_dissim}: Object of class \code{dist} containing the dissimilarities
between every pair of trajectory segments in \code{abundance} (see Details).
\item \code{traj_dissim}: Object of class \code{dist} containing the dissimilarities
between every pair of community trajectories in \code{abundance} (see Details).
}
}
\usage{
EDR_data
}
\description{
Example datasets to characterize and compare EDRs, including abundance data,
state, segment, and trajectory dissimilarity matrices for 90 artificial communities
belonging to three different EDRs.
}
\details{
Artificial data was generated following the procedure explained in Box 1 in
Sánchez-Pinillos et al. (2023) In particular, the initial state of each community was
defined using a hypothetical environmental space with optimal locations for
12 species. Community dynamics were simulated using a general Lotka-Volterra model.

State dissimilarities were calculated using the Bray-Curtis metric. Segment and
trajectory dissimilarities were calculated using the package 'ecotraj'.
}
\references{
Sánchez-Pinillos, M., Kéfi, S., De Cáceres, M., Dakos, V. 2023. Ecological Dynamic
Regimes: Identification, characterization, and comparison. \emph{Ecological Monographs}.
\url{doi:10.1002/ecm.1589}
}
\keyword{datasets}
