% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_pred}
\alias{plot_pred}
\title{Plot predicted versus observed values}
\usage{
plot_pred(predicted, observed, perfect_line = TRUE, outlier_idx = NULL,
  labs = NULL, xlab = "Observed", ylab = "Predicted", title = "")
}
\arguments{
\item{predicted}{numeric vector of predictions}

\item{observed}{numeric vector of observations}

\item{perfect_line}{logical whether to plot a blue 45 degree line
on which perfect predictions would fall}

\item{outlier_idx}{integer indices of outliers to be labelled
between the predicted and observed value pairs are labeled an outlier}

\item{labs}{character labels for points, applied to a subset determined by the
'outlier_criterion'}

\item{xlab}{character label for the x-axis, defaults to "Observed"}

\item{ylab}{character label for the y-axis, defaults to "Predicted"}

\item{title}{character title defaults to ""}
}
\value{
a ggplot object
}
\description{
Plot predicted versus observed values
}
\examples{
library(randomForest)
library(edarf)
fit <- randomForest(hp ~ ., mtcars)
pred <- predict(fit, newdata = mtcars, OOB = TRUE)
plot_pred(pred, mtcars$hp,
          outlier_idx = which(abs(pred - mtcars$hp) > .5 * sd(mtcars$hp)),
          labs = row.names(mtcars))
}

