% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_involvement.R
\name{resource_involvement}
\alias{resource_involvement}
\alias{resource_involvement.eventlog}
\alias{resource_involvement.grouped_eventlog}
\title{Metric: Resource Involvement}
\usage{
resource_involvement(eventlog, level, append, ...)

\method{resource_involvement}{eventlog}(eventlog, level = c("case",
  "resource", "resource-activity"), append = F, append_column = NULL,
  sort = TRUE, ...)

\method{resource_involvement}{grouped_eventlog}(eventlog,
  level = c("case", "resource", "resource-activity"), append = F,
  append_column = NULL, sort = TRUE, ...)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.
\code{eventlog}.}

\item{level}{Level of granularity for the analysis: log,  case, activity, resource or resource-activity.
For more information, see \code{vignette("metrics", "edeaR")}}

\item{append}{Logical, indicating whether to append results to original event log. Ignored when level is log or trace.}

\item{...}{Deprecated arguments}

\item{append_column}{Which of the output columns to append to log, if append = T. Default column depends on chosen level.}

\item{sort}{Sort output on count. Defaults to TRUE. Only for levels with frequency count output.}
}
\description{
Calculates for each resource/resource-activity in what percentage of cases it is present.
}
\details{
Next to the resource frequency, the involvement of resources in cases can be of interest to, e.g., decide how "indispensable"
they are. This metric is provided on three levels of analysis, which are the cases,
the resources, and the resource-activity combinations

\itemize{

\item At the level of the specific
cases, the absolute and relative number of distinct resources executing activities
in each case is calculated. This way a company gets an overview of which
cases are handled by a small amount of resources and which cases need more
resources, indicating a higher level of variance in the process.

\item On the level of the distinct resources,
this metric provides the absolute and relative number of cases in which each
resource is involved, indicating which resources are more "necessary" within the
business process than the others.

\item On the level of the specific
resource-activity combinations, this metric provides a list of all resource-activity
combinations with the absolute and relative number of cases in which each resource-activity combination is involved.

}
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Resource involvement for eventlog

\item \code{grouped_eventlog}: Resource involvement for grouped eventlog
}}

\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
