% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_lifecycle.R
\name{filter_lifecycle}
\alias{filter_lifecycle}
\alias{filter_lifecycle.eventlog}
\alias{filter_lifecycle.grouped_eventlog}
\alias{ifilter_lifecycle}
\title{Filter: Life cycle}
\usage{
filter_lifecycle(eventlog, lifecycle, reverse, ...)

\method{filter_lifecycle}{eventlog}(eventlog, lifecycle, reverse = FALSE, ...)

\method{filter_lifecycle}{grouped_eventlog}(eventlog, lifecycle, reverse = FALSE, ...)

ifilter_lifecycle(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{lifecycle}{Character vector containing one or more life cycle identifiers.}

\item{reverse}{Logical, indicating whether the selection should be reversed.}

\item{...}{Deprecated arguments.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters the log based on the life cycle id
}
\details{
The method filter_lifecycle can be used to filter on life cycle identifiers. It has an lifecycle argument,
to which a vector of identifiers can be given. The selection can be negated with the reverse argument.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter eventlog on life cycle labels

\item \code{grouped_eventlog}: Filter grouped eventlog on life cycle labels
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
