% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adult_coefs.R
\docType{data}
\name{adult_interaction}
\alias{adult_interaction}
\title{Adult Interaction Factors - Table 9}
\format{An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with
2 rows and 7 columns
\describe{
\item{int_group}{Interaction group (M/H)}
\item{used}{Whether or not the category is used in the RA model}
\item{plat, gold, silver, bronze, cat}{HCC grouping risk score for each
metal level}
}}
\source{
Most recent DIY entry at:
\url{https://www.cms.gov/cciio/Resources/Regulations-and-Guidance/index} \cr
Data import and cleaning at:
\url{https://github.com/ArctiCondor/edgedata/tree/master/data-raw}
}
\usage{
adult_interaction
}
\description{
A dataset containing the adult model interaction factors for the risk
adjustment model. Certain HCCs are considered "high risk" HCCs, and when
one of these high risk HCCs interacts with certain other HCCs, an additional
interaction term is added to the risk score.
}
\seealso{
Other factors: 
\code{\link{adult_demo}},
\code{\link{adult_enroll_dur}},
\code{\link{adult_group}},
\code{\link{adult_hcc}},
\code{\link{adult_rxc_hcc_inter}},
\code{\link{adult_rxc}},
\code{\link{child_demo}},
\code{\link{child_group}},
\code{\link{child_hcc}},
\code{\link{infant_demo}},
\code{\link{infant_mat_sev}}

Other HCC tables: 
\code{\link{adult_group}},
\code{\link{adult_hcc}},
\code{\link{adult_rxc_hcc_inter}},
\code{\link{cc_hier}},
\code{\link{child_group}},
\code{\link{child_hcc}},
\code{\link{cpt_hcpcs}},
\code{\link{icd_cc}}
}
\concept{HCC tables}
\concept{factors}
\keyword{datasets}
