% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLambda.R
\name{getLambda}
\alias{getLambda}
\title{Retrieve the lambda values for all or specific outcomes 
for each learning event.}
\usage{
getLambda(data, lambda = 1, split = "_", select.outcomes = NULL)
}
\arguments{
\item{data}{Data with columns \code{Cues} and \code{Outcomes},
as generated with \code{\link{createTrainingData}}.}

\item{lambda}{Numeric, value of lambda parameter. Defaults to 1.}

\item{split}{String, separator between cues or outcomes.}

\item{select.outcomes}{Optional selection of outcomes to limit the number of 
activations that are returned. The value of NULL (default) will 
return all activations. Note that specified values that are not in 
the weightmatrices will return the initial value without error or warning. 
Please use  \code{\link{getValues}} for returning all outcomes in the data.}
}
\value{
Data frame.
}
\description{
For a given set of training data, 
the lambda values are returned for each or specific outcomes. 
The values are returned as data frame.
}
\examples{
# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
head(dat)
dim(dat)
test <- getLambda(dat)
# only outcomes that do not occur in data results in 0:
test2 <- getLambda(dat, select.outcomes=c("a", "b", "C"))

}
\author{
Jacolien van Rij
}
