% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/leading_zero.R
\name{leading_zero}
\alias{leading_zero}
\title{Function to add leading zeroes to maintain fixed width.}
\usage{
leading_zero(x, digits = 2)
}
\arguments{
\item{x}{a vector of numeric data that should be fixed width but is
missing leading zeroes.}

\item{digits}{an integer representing the desired width of \code{x}}
}
\value{
A character vector of length \code{digits}
}
\description{
This function ensures that fixed width data is the right
length by padding zeroes to the front of values. This is a common problem
with fixed width data after importing into R as non-character type.
}
\details{
If x contains negative values then the width specified by digits
will include one space taken up for the negative sign. The function does not
trim values that are longer than digits, so the vector produced will not
have a uniform width if \code{nchar(x) > d}
}
\examples{
a <- seq(1,10)
a <- leading_zero(a, digits = 3)
a
}
\author{
Jason P. Becker

Jared E. Knowles
}

