% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_dependence.R
\name{.pd}
\alias{.pd}
\title{Barebone Partial Dependence}
\usage{
.pd(
  object,
  v,
  data,
  grid,
  pred_fun = stats::predict,
  trafo = NULL,
  which_pred = NULL,
  w = NULL,
  ...
)
}
\arguments{
\item{object}{Fitted model.}

\item{v}{Variable name in \code{data} to calculate partial dependence.}

\item{data}{Matrix or data.frame.}

\item{grid}{Vector or factor of values to calculate partial dependence for.}

\item{pred_fun}{Prediction function, by default \code{stats::predict}.
The function takes three arguments (names irrelevant): \code{object}, \code{data}, and \code{...}.}

\item{trafo}{How should predictions be transformed?
A function or \code{NULL} (default). Examples are \code{log} (to switch to link scale)
or \code{exp} (to switch from link scale to the original scale).}

\item{which_pred}{If the predictions are multivariate: which column to pick
(integer or column name). By default \code{NULL} (picks last column).}

\item{w}{Optional vector with case weights.}

\item{...}{Further arguments passed to \code{pred_fun()}, e.g., \code{type = "response"} in
a \code{glm()} or (typically) \code{prob = TRUE} in classification models.}
}
\value{
Vector of partial dependence values in the same order as \code{grid}.
}
\description{
This is a barebone implementation of Friedman's partial dependence
intended for developers. To get more information on partial dependence, see
\code{\link[=partial_dependence]{partial_dependence()}}.
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
.pd(fit, "Sepal.Width", data = iris, grid = hist(iris$Sepal.Width)$mids)
.pd(fit, "Species", data = iris, grid = levels(iris$Species))
}
\references{
Friedman, Jerome H. 2001, \emph{Greedy Function Approximation: A Gradient Boosting Machine.}
Annals of Statistics 29 (5): 1189-1232. doi:10.1214/aos/1013203451.
}
\seealso{
\code{\link[=partial_dependence]{partial_dependence()}}
}
