% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expose_layout.r
\name{expose_layout}
\alias{expose_layout}
\title{expose_layout}
\usage{
expose_layout(p, draw = TRUE, newpage = TRUE)
}
\arguments{
\item{p}{ggplot}

\item{draw}{logical, draw the gtable}

\item{newpage}{logical}
}
\value{
gtable
}
\description{
Schematic view of a ggplot object's layout.
}
\examples{
p1 <- qplot(mpg, wt, data=mtcars, colour=cyl)
p2 <- qplot(mpg, data = mtcars) + ggtitle("title")
p3 <- qplot(mpg, data = mtcars, geom = "dotplot")
p4 <- p1 + facet_wrap(~carb, nrow=1) + theme(legend.position="none") +
  ggtitle("facetted plot")
pl <- lapply(list(p1,p2, p3, p4), expose_layout, FALSE, FALSE)
grid.arrange(grobs=pl, widths=c(1.2,1,1),
             layout_matrix = rbind(c(1, 2, 3),
                                   c(4, 4, 4)))
}
