% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Loglogistic.R
\name{Loglogistic}
\alias{Loglogistic}
\alias{pllogis}
\alias{Llogis}
\alias{dllogis}
\alias{qllogis}
\alias{hllogis}
\alias{Hllogis}
\alias{rllogis}
\title{The Loglogistic Distribution}
\usage{
dllogis(x, shape = 1, scale = 1, log = FALSE) 
pllogis(q, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE) 
qllogis(p, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE) 
hllogis(x, shape = 1, scale = 1, prop = 1, log = FALSE) 
Hllogis(x, shape = 1, scale = 1, prop = 1, log.p = FALSE) 
rllogis(n, shape = 1, scale = 1)
}
\arguments{
\item{shape, scale}{shape and scale parameters, both defaulting to 1.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P(X \le
x)}{P(X <= x)}, otherwise, \eqn{P(X > x)}{P(X > x)}.}

\item{x, q}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is
taken to be the number required.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{prop}{proportionality constant in the extended Loglogistic distribution.}
}
\value{
\code{dllogis} gives the density, \code{pllogis} gives the distribution
function, \code{qllogis} gives the quantile function, \code{hllogis} gives the
hazard function, \code{Hllogis} gives the cumulative hazard function, and
\code{rllogis} generates random deviates.

Invalid arguments will result in return value \code{NaN}, with a warning.
}
\description{
Density, distribution function, quantile function, hazard function,
cumulative hazard function, and random generation for the Loglogistic distribution
with parameters \code{shape} and \code{scale}.
}
\details{
The Loglogistic distribution with \code{scale} parameter \eqn{a} and \code{shape}
parameter \eqn{\sigma}{b} has hazard function given by \deqn{h(x) =
(b/\sigma)(x/\sigma)^(b-1)\exp((x / \sigma)^b)}{% h(x) =
(b/a)(x/a)^(b-1)exp((x / a)^b)} for \eqn{x \ge 0}{x >= 0}.
}
\keyword{distribution}
