% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compHaz.R
\name{compHaz}
\alias{compHaz}
\title{Graphical comparison of cumulative hazards}
\usage{
compHaz(
  fit1,
  fit2,
  main = NULL,
  lty = 1:2,
  col = c("red", "blue"),
  printLegend = TRUE
)
}
\arguments{
\item{fit1}{An object of type "coxreg", "phreg", or other output from
from survival fitters.}

\item{fit2}{An object of type "coxreg", "phreg", or other output from
survival fitters.}

\item{main}{Header for the plot. Default is \code{NULL}.}

\item{lty}{line types.}

\item{col}{Line colors. should be \code{NULL} (black lines) or of length 2.}

\item{printLegend}{Should a legend be printed? Default is \code{TRUE}.}
}
\value{
No return value.
}
\description{
Comparison of the estimated baseline cumulative hazards functions for two survival models.
}
\examples{

fit.cr <- coxreg(Surv(enter, exit, event) ~ sex, data = oldmort)
fit.w <- phreg(Surv(enter, exit, event) ~ sex, data = oldmort)
compHaz(fit.cr, fit.w)
}
\seealso{
\code{\link{hazards}}, \code{\link{coxreg}}, and \code{\link{phreg}}.
}
\author{
Göran Broström
}
\keyword{distribution}
