% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei_rxc.R
\name{ei_rxc}
\alias{ei_rxc}
\title{EI Bayesian simultaneous estimation for multiple races and candidates}
\usage{
ei_rxc(
  data,
  cand_cols,
  race_cols,
  totals_col,
  name = "",
  ntunes = 10,
  totaldraws = 10000,
  samples = 1e+05,
  thin = 1,
  burnin = 10000,
  ci_size = 0.95,
  seed = NULL,
  eiCompare_class = TRUE,
  ret_mcmc = FALSE,
  verbose = FALSE,
  diagnostic = FALSE,
  n_chains = 3,
  plot_path = "",
  par_compute = FALSE,
  ...
)
}
\arguments{
\item{data}{A data.frame() object containing precinct-level turnout data by
race and candidate}

\item{cand_cols}{A character vector listing the column names for turnout for
each candidate}

\item{race_cols}{A character vector listing the column names for turnout by
race}

\item{totals_col}{The name of the column containing total votes cast in each
precinct}

\item{name}{A unique identifier for the outputted eiCompare object.}

\item{ntunes}{Integer number of pre-MCMC tuning runs, defaulted to 10}

\item{totaldraws}{Integer number of iterations per run in pre-MCMC tuning
runs, defaulted to 10000}

\item{samples}{Integer number of draws saved and used to compute estimates.
Total chain length is sample*thin + burnin}

\item{thin}{Integer specifying the thinning interval for posterior draws. Eg.
if thin = 2, every second draw gets added to the sample}

\item{burnin}{Integery specifying the number of initial iterations to be
discarded, defaulted to 10000}

\item{ci_size}{Numeric desired probability within the upper and lower
credible-interval bounds, defaulted to 0.95}

\item{seed}{A numeric seed value for replicating estimate results across
runs. If NULL, a random seed is chosen. Defaulted to NULL.}

\item{eiCompare_class}{default = TRUE}

\item{ret_mcmc}{Boolean. If true, the full sample chains are returned}

\item{verbose}{A boolean indicating whether to print out status messages.}

\item{diagnostic}{Boolean. If true, run diagnostic test to assess viability of MCMC
parameters (will return all chain results)}

\item{n_chains}{Number of chains for diagnostic test. Default is set to 3.}

\item{plot_path}{A string to specify plot save location. Defaulted to working directory}

\item{par_compute}{Boolean. If true, diagnostic test will be run in parallel.}

\item{...}{Additional parameters passed to eiPack::tuneMD()}
}
\value{
If ret_mcmc == TRUE, a list is returned containing results and a data
frame of the full chains from the MCMC. If ret_mcmc == FALSE, results are
returned in a dataframe

A dataframe of ei results
}
\description{
EI Bayesian simultaneous estimation for multiple races and candidates
}
\references{
eiPack, King et al., (http://gking.harvard.edu/eiR)
}
\author{
Loren Collingwood <loren.collingwood@ucr.edu>, <loren.collingwood@gmail.com>

Hikari Murayama <hikari_murayama@berkeley.edu>

Ari Decter-Frain <agd75@cornell.edu>
}
