% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generateBounds}
\alias{generateBounds}
\title{Compute bounds and summary statistics according to Jiang et al. 2019}
\usage{
generateBounds(x, t, n, trueBetaB = NULL, useXRangeOffset = TRUE,
  returnAdditionalStats = FALSE, printSummary = TRUE)
}
\arguments{
\item{x}{Numeric (double-precision) vector. Contains the proportion of variable X in each precinct (or analagous geographic unit)}

\item{t}{Numeric (double-precision) vector. Contains the proportion of variable T in each precinct (or analagous geographic unit)}

\item{n}{Numeric (double-precision) vector. Contains the number of elements (people/households/etc.) in each precinct (or analagous geographic unit)}

\item{trueBetaB}{Numeric (double-precision) vector. Contains the true conditional values (beta_i) in each precinct (or analagous geographic unit).
Optional. Default NULL.}

\item{useXRangeOffset}{boolean If True, an offset of 0.00001 is applied to l and u to avoid division by 0 in subsequent calculations. Default TRUE}

\item{returnAdditionalStats}{boolean If True, additional summary statistics are generated. Default FALSE.}

\item{printSummary}{boolean If True, the DD bounds, l and u, CI_0, CI_1, width-ratio, and (optionally) true district B are output to standard out. Default TRUE.}
}
\value{
List object with the bounds and summary statistics:

 nx1 Total elements (people/households/etc.) of variable X across all geographic units

 hbdl0 CI_0 lower bound

 hbdu0 CI_0 upper bound

 cil CI_1 lower bound

 cir CI_1 upper bound

 bdl Duncan-Davis lower bound

 bdu Duncan-Davis upper bound

 Optional: bd True district Beta
}
\description{
\code{generateBounds()} calculates district-level bounds. The returned object can be passed to evaluateBounds() to generate bounds across varying coverage probabilities
and to apply the heuristics presented in Jiang et al. 2019.
}
\examples{
library("MASS")
library("eco")
data("census")
inputDataSet <- census
x <- inputDataSet$X
t <- inputDataSet$Y
n <- inputDataSet$N
trueBetaB <- inputDataSet$W1
outputList <- generateBounds(x, t, n, trueBetaB=trueBetaB, useXRangeOffset=TRUE,
    returnAdditionalStats=FALSE, printSummary=TRUE)

# True B: 0.674809
# Duncan-Davis bounds: [0.535618, 0.974010]
# [l,u]=[min(X_i),max(X_i)]: [0.050810, 0.939290]
# CI_0=[Bl_hat, Bu_hat]: [0.606101, 0.810082]
# CI_1: [0.572566, 0.842403]
# Width-ratio: |CI_0|/|DD|: 0.465295

}
