% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalplot.R
\name{marginalplot}
\alias{marginalplot}
\title{Plots of Estimated Marginal Effects in Explanatory IRT Models}
\usage{
marginalplot(x, predictors, conf.int = 0.95, plot.title = NULL)
}
\arguments{
\item{x}{An eirm object returned from the \code{\link{eirm}} function.}

\item{predictors}{Character vector with the names of up to three categorical predictors from the eirm model. The first predictor
is plotted on the x-axis; the second predictor is used as a group variable; the third predictor is used as
a facet in the plot.}

\item{conf.int}{Confidence interval to be used in the plot (default = 0.95 for 95\% confidence intervals).}

\item{plot.title}{A title to be used in the plot.}
}
\value{
A ggplot2 object.
}
\description{
This function uses \code{\link[ggeffects]{ggpredict}} to calculate marginal effects for explanatory variables in
an explanatory IRT model estimated with the \code{\link{eirm}} function. It returns a plot of estimated probabilities
generated by the explanatory IRT model while holding some predictors constant.
}
\examples{
data("VerbAgg")
mod <- eirm(formula = "r2 ~ -1 + situ + btype + mode + (1|id)", data = VerbAgg)

# Only one predictor
p1 <- marginalplot(mod, predictors = c("situ"))

# Two predictors
p2 <- marginalplot(mod, predictors = c("situ", "btype"))

# All three predictors
p3 <- marginalplot(mod, predictors = c("situ", "btype", "mode"))
}
