% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presidential_vote.R
\name{president_mun_vote}
\alias{president_mun_vote}
\title{Download, clean, and transform data on presidential electoral runoff results by municipality}
\usage{
president_mun_vote(year, prop = TRUE, ascii = FALSE, encoding = "Latin-1")
}
\arguments{
\item{year}{Election year (\code{integer}). For this function, only the years 1998, 2002, 2006, 2010, and 2014
are available.}

\item{prop}{Shoud the votes be reported as proportion? (Defaults to \code{TRUE}).}

\item{ascii}{(\code{logical}). Should the text be transformed from Latin-1 to ASCII format?}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}
}
\value{
\code{president_mun_vote()} returns a \code{tbl, data.frame} with the following variables:

\itemize{
  \item ANO_ELEICAO: Election year.
  \item SIGLA_UF: Unit of the Federation's acronym in which occurred the election.
  \item CODIGO_MUNICIPIO: Supreme Electoral code from the city where occurred the election.
  \item NOME_MUNICIPIO: Name of the city where occurred the election.
  \item SIGLA_PARTIDO: Party acronym.
  \item NOME_PARTIDO: Party name.
  \item NUMERO_PARTIDO: Party number.
  \item NOME_COLIGACAO: Coalition shortname.
  \item COMPOSICAO_LEGENDA: Party's shortname composition.
  \item TOTAL_VOTOS: Party total votes by state.
}
}
\description{
\code{president_mun_vote()} downloads, cleans, and transforms data on presidential elections results
in the second round (runnoff elections) by municipality. The electoral results are, by default, reported as proportion.
}
\details{
This functions includes results to BR and ZZ state acronyms: the first one considers the entire
country as a district; the second one considers voters living abroad as a district. For 2014 elections,
results are only available for these two state acronyms.
}
\examples{
\dontrun{
df <- president_mun_vote(2002)
}
}
\seealso{
\code{\link{president_state_vote}} for presidential elections results by state;
\code{\link{legislative_mun_vote}} for legislative elections results by municipality;
and \code{\link{legislative_state_vote}} for legislative elections results by state.
}
