% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{overlap}
\alias{overlap}
\title{Multiple scaling -- the overlapping way}
\usage{
overlap(
  msdf,
  mrit_min = NULL,
  negative_too = FALSE,
  overlap_with = "fragment",
  sclvals = NULL,
  use = "pairwise.complete.obs"
)
}
\arguments{
\item{msdf}{a multiple scaled data frame (built with \code{disjoint()}).}

\item{mrit_min}{a numeric constant of length 1 to specify the marginal
corrected item-total correlation. Its value is in the range of 0-1. The
default is set to \code{.3}.}

\item{negative_too}{a logical constant indicating whether reversed items are
included in the analysis. The default is set to \code{FALSE}.}

\item{overlap_with}{a string telling \code{overlap()} the set of items for
the extension. To build up on all variables of a fragment use
\code{fragment}, for the core-only option type \code{core}. The default is
set to "fragment".}

\item{sclvals}{a numeric vector of length 2 indicating the start- and
endpoint of a scale. Use something like \code{c(min,max)}.}

\item{use}{an optional string to specify how missing values enter the
analysis. See \code{use} in \code{\link[stats]{cor}} for details. The
default is set to \code{pairwise.complete.obs}.}
}
\value{
A multiple scaled data frame (\code{msdf}).
}
\description{
\code{overlap()} returns a overlapped version (either extended,
  or reversed, or both) of the specified \code{msdf}.
}
\details{
\code{use} clarifies how to set up a correlation matrix in the
  presence of missing values. In a typical scaling process this happens at
  least twice. First, when determining the core items (the two items in the
  correlation matrix with the highest linear relationship). Second, when an
  item is proposed for an emerging scale.

  Note that \code{overlap()} uses \code{\link[stats]{cor}}'s default
  method \code{pearson}.
}
\examples{
# Build a msdf
msdf <- disjoint(mtcars, mrit_min = .4)

# Use positive correlations (extend on fragments)
overlap(msdf, mrit_min = .6)

# Use positive correlations (extend on cores)
overlap(msdf, mrit_min = .6, overlap_with = "core")

# Include negative correlations
overlap(msdf, mrit_min = .7, negative_too = TRUE, sclvals = c(-3,3))

# Change the treatment of missing values
overlap(msdf, mrit_min = .6, use = "all.obs")

}
\references{
Müller-Schneider, T. (2001). Multiple Skalierung nach dem
  Kristallisationsprinzip / Multiple Scaling According to the Principle of
  Crystallization. Zeitschrift für Soziologie, 30(4), 305-315.
  https://doi.org/10.1515/zfsoz-2001-0404
}
