% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch-chat.R
\name{batch_chat}
\alias{batch_chat}
\alias{batch_chat_text}
\alias{batch_chat_structured}
\alias{batch_chat_completed}
\title{Submit multiple chats in one batch}
\usage{
batch_chat(chat, prompts, path, wait = TRUE)

batch_chat_text(chat, prompts, path, wait = TRUE)

batch_chat_structured(
  chat,
  prompts,
  path,
  type,
  wait = TRUE,
  convert = TRUE,
  include_tokens = FALSE,
  include_cost = FALSE
)

batch_chat_completed(chat, prompts, path)
}
\arguments{
\item{chat}{A base chat object.}

\item{prompts}{A vector created by \code{\link[=interpolate]{interpolate()}} or a list
of character vectors.}

\item{path}{Path to file (with \code{.json} extension) to store state.

The file records a hash of the provider, the prompts, and the existing
chat turns. If you attempt to reuse the same file with any of these being
different, you'll get an error.}

\item{wait}{If \code{TRUE}, will wait for batch to complete. If \code{FALSE},
it will return \code{NULL} if the batch is not complete, and you can retrieve
the results later by re-running \code{batch_chat()} when
\code{batch_chat_completed()} is \code{TRUE}.}

\item{type}{A type specification for the extracted data. Should be
created with a \code{\link[=type_boolean]{type_()}} function.}

\item{convert}{If \code{TRUE}, automatically convert from JSON lists to R
data types using the schema. This typically works best when \code{type} is
\code{\link[=type_object]{type_object()}} as this will give you a data frame with one column for
each property. If \code{FALSE}, returns a list.}

\item{include_tokens}{If \code{TRUE}, and the result is a data frame, will
add \code{input_tokens} and \code{output_tokens} columns giving the total input
and output tokens for each prompt.}

\item{include_cost}{If \code{TRUE}, and the result is a data frame, will
add \code{cost} column giving the cost of each prompt.}
}
\value{
For \code{batch_chat()}, a list of \link{Chat} objects, one for each prompt.
For \code{batch_chat_test()}, a character vector of text responses.
For \code{batch_chat_structured()}, a single structured data object with one
element for each prompt. Typically, when \code{type} is an object, this will
will be a data frame with one row for each prompt, and one column for each
property.

For any of the aboves, will return \code{NULL} if \code{wait = FALSE} and the job
is not complete.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{batch_chat()} and \code{batch_chat_structured()} currently only work with
\code{\link[=chat_openai]{chat_openai()}} and \code{\link[=chat_anthropic]{chat_anthropic()}}. They use the
\href{https://platform.openai.com/docs/guides/batch}{OpenAI} and
\href{https://docs.anthropic.com/en/docs/build-with-claude/batch-processing}{Anthropic}
batch APIs which allow you to submit multiple requests simultaneously.
The results can take up to 24 hours to complete, but in return you pay 50\%
less than usual (but note that ellmer doesn't include this discount in
its pricing metadata). If you want to get results back more quickly, or
you're working with a different provider, you may want to use
\code{\link[=parallel_chat]{parallel_chat()}} instead.

Since batched requests can take a long time to complete, \code{batch_chat()}
requires a file path that is used to store information about the batch so
you never lose any work. You can either set \code{wait = FALSE} or simply
interrupt the waiting process, then later, either call \code{batch_chat()} to
resume where you left off or call \code{batch_chat_completed()} to see if the
results are ready to retrieve. \code{batch_chat()} will store the chat responses
in this file, so you can either keep it around to cache the results,
or delete it to free up disk space.

This API is marked as experimental since I don't yet know how to handle
errors in the most helpful way. Fortunately they don't seem to be common,
but if you have ideas, please let me know!
}
\examples{
\dontshow{if (has_credentials("openai")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
chat <- chat_openai(model = "gpt-4.1-nano")

# Chat ----------------------------------------------------------------------

prompts <- interpolate("What do people from {{state.name}} bring to a potluck dinner?")
\dontrun{
chats <- batch_chat(chat, prompts, path = "potluck.json")
chats
}

# Structured data -----------------------------------------------------------
prompts <- list(
  "I go by Alex. 42 years on this planet and counting.",
  "Pleased to meet you! I'm Jamal, age 27.",
  "They call me Li Wei. Nineteen years young.",
  "Fatima here. Just celebrated my 35th birthday last week.",
  "The name's Robert - 51 years old and proud of it.",
  "Kwame here - just hit the big 5-0 this year."
)
type_person <- type_object(name = type_string(), age = type_number())
\dontrun{
data <- batch_chat_structured(
  chat = chat,
  prompts = prompts,
  path = "people-data.json",
  type = type_person
)
data
}
\dontshow{\}) # examplesIf}
}
