% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.run.helpers.R
\name{elo.run.helpers}
\alias{elo.run.helpers}
\alias{as.matrix.elo.run}
\alias{as.data.frame.elo.run}
\alias{last}
\alias{last.elo.run}
\title{Helper functions for \code{elo.run}}
\usage{
\method{as.matrix}{elo.run}(x, ...)

\method{as.data.frame}{elo.run}(x, ...)

last(x, ...)

\method{last}{elo.run}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"elo.run"}.}

\item{...}{Other arguments (Not in use at this time).}
}
\value{
A matrix, a data.frame, or a named vector.
}
\description{
\code{as.matrix.elo.run} converts an object from \code{\link{elo.run}} into a matrix of running Elos.
}
\details{
\code{as.data.frame.elo.run} converts the \code{"elos"} component of an object from \code{\link{elo.run}} into a data.frame.

\code{last} is a generic function, whose \code{\link{elo.run}} method extracts the last Elo per team.
}
\examples{
e <- elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
             data = tournament, k = 20)
head(as.matrix(e))
str(as.data.frame(e))
last(e)
}
\seealso{
\code{\link{elo.run}}
}
