% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.emBayes.R
\name{cv.emBayes}
\alias{cv.emBayes}
\title{k-folds cross-validation for 'emBayes'}
\usage{
cv.emBayes(
  y,
  clin = NULL,
  X,
  quant,
  t0,
  t1,
  k,
  func,
  error = 0.01,
  maxiter = 200
)
}
\arguments{
\item{y}{a vector of response variable.}

\item{clin}{a matrix of clinical factors. It has default value NULL.}

\item{X}{a matrix of genetic factors.}

\item{quant}{value of quantile.}

\item{t0}{a user-supplied sequence of the spike scale \eqn{s_{0}}.}

\item{t1}{a user-supplied sequence of the slab scale \eqn{s_{1}}.}

\item{k}{number of folds for cross-validation.}

\item{func}{methods to perform variable selection. Two choices are available: "ssLASSO" and "ssQLASSO".}

\item{error}{cutoff value for determining convergence. The algorithm reaches convergence if the difference in the expected log-likelihood of two iterations is less than the value of error. The default value is 0.01.}

\item{maxiter}{the maximum number of iterations that is used in the estimation algorithm. The default value is 200.}
}
\value{
A list with components:
\item{CL.s0}{the optimal spike scale under check loss.}
\item{CL.s1}{the optimal slab scale under check loss.}
\item{SL.s0}{the optimal slab scale under least squares loss.}
\item{SL.s1}{the optimal slab scale under least squares loss.}
\item{SIC.s0}{the optimal slab scale under SIC.}
\item{SIC.s1}{the optimal slab scale under SIC.}
\item{CL.CV}{cross-validation error matrix under check loss.}
\item{SL.CV}{cross-validation error matrix under least squares loss.}
\item{SIC.CV}{cross-validation error matrix under SIC.}
}
\description{
This function performs cross-validation and returns the optimal values of the tuning parameters.
}
\details{
When performing cross-validation for emBayes, function cv.emBayes returns two sets of optimal tuning parameters and their corresponding cross-validation error matrices. 
The spike scale parameter \eqn{CL.s0} and the slab scale parameter \eqn{CL.s1} are obtained based on the quantile check loss. 
The spike scale parameter \eqn{SL.s0} and the slab scale parameter \eqn{SL.s1} are obtained based on the least squares loss. 
The spike scale parameter \eqn{SIC.s0} and the slab scale parameter \eqn{SIC.s1} are obtained based on the Schwarz Information Criterion (SIC).
Corresponding error matrices \eqn{CL.CV}, \eqn{SL.CV} and \eqn{SIC.CV} can also be obtained from the output.

Schwarz Information Criterion has the following form:
\deqn{SIC=\log\sum_{i=1}^nL(y_i-\hat{y_i})+\frac{\log n}{2n}edf}
where \eqn{L(\cdot)} is the check loss and \eqn{edf} is the number of close to zero residuals \eqn{(\leq 0.001)}.
}
