% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body.R
\name{html}
\alias{html}
\title{Add an HTML body to a message object.}
\usage{
html(
  msg,
  content,
  disposition = "inline",
  charset = "utf-8",
  encoding = "quoted-printable",
  css_files = c(),
  interpolate = TRUE,
  .open = "{{",
  .close = "}}",
  .envir = NULL
)
}
\arguments{
\item{msg}{A message object.}

\item{content}{A string of message content.}

\item{disposition}{How content is presented (Content-Disposition).}

\item{charset}{How content is encoded.}

\item{encoding}{How content is transformed to ASCII (Content-Transfer-Encoding).}

\item{css_files}{Extra CSS files.}

\item{interpolate}{Whether or not to interpolate into input using \link[glue]{glue}.}

\item{.open}{The opening delimiter.}

\item{.close}{The closing delimiter.}

\item{.envir}{Environment used for \code{glue} interpolation. Defaults to \code{parent.frame()}.}
}
\value{
A message object.
}
\description{
Add an HTML body to a message object.
}
\examples{
library(magrittr)

# Inline HTML message.
envelope() \%>\% html("<b>Hello!</b>")

# Read HTML message from a file.
htmlfile <- tempfile(fileext = ".html")
cat("<p>Hello!</p>\n", file = htmlfile)
envelope() \%>\% html(htmlfile)
}
\seealso{
\code{\link{text}}
}
