% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{get_observed_synergies_per_cell_line}
\alias{get_observed_synergies_per_cell_line}
\title{Get observed synergies per cell line}
\usage{
get_observed_synergies_per_cell_line(cell.line.dirs, drug.combos)
}
\arguments{
\item{cell.line.dirs}{a character vector of the cell line directories, in the
form of \emph{\{path\}/cell_line_name}. The cell line name directory
should be different for each element of the vector as we use it to fill in the
\code{rownames} of the result \code{data.frame} object. Inside each cell line directory
we read the observed synergies from a file called \emph{observed_synergies}
(if it exists and is non-empty). This file has the names of the observed
drug combinations, one in each line.}

\item{drug.combos}{a character vector with elements the names of all the drug combinations
that were tested in the analysis.}
}
\value{
a data.frame, whose columns represent the drug combinations tested
and the rows the cell lines. Possible values for each \emph{cell line-drug combination}
element are either \emph{1} (an observed synergy) or \emph{0} (non-observed synergy).
}
\description{
Use this function to get the observed synergies from the respective
files inside the given list of cell line directories.
}
