% Generated by roxygen2 (4.0.2): do not edit by hand
\name{embryogrowth_MHmcmc_p}
\alias{embryogrowth_MHmcmc_p}
\title{Generates set of parameters to be used with embryogrowth_MHmcmc()}
\usage{

  embryogrowth_MHmcmc_p(result = stop("An output from searchR must be provided"),
  accept = FALSE)
}
\arguments{
\item{result}{An object obtained after a SearchR fit}

\item{accept}{If TRUE, the script does not wait user information}
}
\value{
A matrix with the parameters
}
\description{
Interactive script used to generate set of parameters to be used with embryogrowth_MHmcmc().\cr
}
\details{
embryogrowth_MHmcmc_p generates set of parameters to be used with embryogrowth_MHmcmc()
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
# The initial parameters value can be:
# "T12H", "DHA",  "DHH", "Rho25"
# Or
# "T12L", "T12H", "DHA",  "DHH", "DHL", "Rho25"
x <- structure(c(118.768297442004, 475.750095909406, 306.243694918151,
116.055824800264), .Names = c("DHA", "DHH", "T12H", "Rho25"))
# pfixed <- c(K=82.33) or rK=82.33/39.33
pfixed <- c(rK=2.093313)
resultNest_4p <- searchR(parameters=x, fixed.parameters=pfixed,
	temperatures=formated, derivate=dydt.Gompertz, M0=1.7,
	test=c(Mean=39.33, SD=1.92), method = "BFGS", maxiter = 200)
data(resultNest_4p)
pMCMC <- embryogrowth_MHmcmc_p(resultNest_4p, accept=TRUE)
}
}
\author{
Marc Girondot
}

