% Generated by roxygen2 (4.0.1): do not edit by hand
\name{fit}
\alias{fit}
\title{Fit a model}
\usage{
fit(proc, x, y, ..., .verbose)
}
\arguments{
\item{proc}{modeling procedure, or list of modeling procedures, as
produced by \code{\link{modeling.procedure}}.}

\item{x}{Dataset, observations as rows and descriptors as columns.}

\item{y}{Response vector.}

\item{...}{Sent to \code{\link{tune}}, in case tuning is required,
which will pass them on to \code{\link{batch.model}}.}

\item{.verbose}{Whether to print an activity log.}
}
\value{
A list of fitted models.
}
\description{
Fits a model according to a modeling procedure. If the procedure contains
untuned variables they it will automatically be tuned prior to fitting. Note
however that the tuning statistics will not be return.
}
\examples{
proc <- modeling.procedure("lda")
mod <- fit(proc, x=iris[-5], y=iris$Species)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{modeling.procedure}},
  \code{\link{evaluate.modeling}}, \code{\link{tune}},
  \code{\link[=predict.modeling.procedure]{predict}}, \code{\link{vimp}}
}

