% Generated by roxygen2 (4.0.1): do not edit by hand
\name{vimp}
\alias{vimp}
\title{Variable importance of a fitted model}
\usage{
vimp(object, model, ...)
}
\arguments{
\item{object}{Modeling procedure.}

\item{model}{Fitted model.}

\item{...}{Sent on to the procedure's variable importance scoring function.}
}
\value{
A vector of length p or an p-x-c matrix of variable importance
  scores where p is the number of descriptors and c is the number of classes.
}
\description{
Note that different methods calculates variable importance in different
ways and that they are not directly comparable.
}
\examples{
proc <- modeling.procedure("randomForest")
mod <- fit(proc, x=iris[-5], y=iris$Species)
vimp(proc, mod)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}
}

