% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.r
\name{pvalue.coxph}
\alias{pvalue.coxph}
\title{Extract p-value from a Cox proportional hazards model}
\usage{
\method{pvalue}{coxph}(x, log_p = FALSE, test = c("logrank", "wald",
  "likelihood"), ...)
}
\arguments{
\item{x}{Fitted \code{\link[survival]{coxph}} model.}

\item{log_p}{Whether to return the logarithm of the p-value.}

\item{test}{What test to calculate. \code{"likelihood"} is short for means
likelihood ratio test.}

\item{...}{Ignored. Kept for S3 consistency.}
}
\value{
p-value.
}
\description{
Based on \code{\link{summary.coxph}}.
}
\references{
Andersen, P. and Gill, R. (1982). Cox's regression model for
  counting processes, a large sample study. \emph{Annals of Statistics}
  10, 1100-1120.

  Therneau, T., Grambsch, P., Modeling Survival Data: Extending the
  Cox Model.  Springer-Verlag, 2000.
}
\seealso{
\code{\link{pvalue}}
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
