% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.r
\name{fit_coxph}
\alias{fit_coxph}
\title{Fit Cox proportional hazards model}
\usage{
fit_coxph(x, y, formula = y ~ ., ...)
}
\arguments{
\item{x}{Dataset.}

\item{y}{Response. Required if formula is missing.}

\item{formula}{See \code{\link{coxph}}.}

\item{...}{Sent to \code{\link{coxph}}.}
}
\value{
Fitted Cox proportional hazards model.
}
\description{
Fit Cox proportional hazards model
}
\examples{
if(requireNamespace("survival")){

  data("ovarian", package = "survival")
  model <- fit(
      modeling_procedure(
          method = "coxph",
          parameter = list(formula = list(survival::Surv(futime, fustat) ~ age))),
      x = ovarian, y = NULL
  )
  predict(model, ovarian[11:16,])

}
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{predict_coxph}}
}

