% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R, R/test.R
\name{summary.emmGrid}
\alias{summary.emmGrid}
\alias{predict.emmGrid}
\alias{confint.emmGrid}
\alias{test}
\alias{test.emmGrid}
\title{Summaries, predictions, intervals, and tests for \code{emmGrid} objects}
\usage{
\method{summary}{emmGrid}(object, infer, level, adjust, by, type, df, null,
  delta, side, ...)

\method{predict}{emmGrid}(object, type, ...)

\method{confint}{emmGrid}(object, parm, level = 0.95, ...)

test(object, null, ...)

\method{test}{emmGrid}(object, null = 0, joint = FALSE, verbose = FALSE,
  rows, by, ...)
}
\arguments{
\item{object}{An object of class \code{"emmGrid"} (see \link{emmGrid-class})}

\item{infer}{A vector of one or two two logical values. The first determines
whether confidence intervals are displayed, and the second determines
whether \emph{t} tests and \emph{P} values are displayed. If only one value
is provided, it is used for both.}

\item{level}{Numerical value between 0 and 1. Confidence level for confidence
intervals, if \code{infer[1]} is \code{TRUE}.}

\item{adjust}{Character value naming the method used to adjust \eqn{p} values
or confidence limits; or to adjust comparison arrows in \code{plot}. See
Details.}

\item{by}{Character name(s) of variables to use for grouping into separate 
tables. This affects the family of tests considered in adjusted \emph{P}
values.}

\item{type}{Character: type of prediction desired. This only has an effect if
there is a known transformation or link function. \code{"response"}
specifies that the inverse transformation be applied. \code{"mu"} (or
equivalently, \code{"unlink"}) is usually the same as \code{"response"}, but
in the case where the model has both a link function and a response
transformation, only the link part is back-transformed. Other valid values
are \code{"link"}, \code{"lp"}, and \code{"linear.predictor"}; these are equivalent,
and request that results be shown for the linear predictor, with no 
back-transformation. The default is \code{"link"}, unless the 
\code{"predict.type"} option is in force; see \code{\link{emm_options}}.}

\item{df}{Numeric. If non-missing, a constant number of degrees of freedom to
use in constructing confidence intervals and \emph{P} values (\code{NA}
specifies asymptotic results).}

\item{null}{Numeric. Null hypothesis value(s), on the linear-predictor scale,
against which estimates are tested. May be a single value used for all, or
a numeric vector of length equal to the number of tests in each family
(i.e., \code{by} group in the displayed table).}

\item{delta}{Numeric value (on the linear-predictor scale). If zero, ordinary
tests of significance are performed. If positive, this specifies a
threshold for testing equivalence (using the TOST or two-one-sided-test
method), non-inferiority, or non-superiority, depending on \code{side}. See
Details for how the test statistics are defined.}

\item{side}{Numeric or character value specifying whether the test is
left-tailed (\code{-1}, \code{"-"}, code{"<"}, \code{"left"}, or
\code{"nonsuperiority"}); right-tailed (\code{1}, \code{"+"}, \code{">"},
\code{"right"}, or \code{"noninferiority"}); or two-sided (\code{0},
\code{2}, \code{"!="}, \code{"two-sided"}, \code{"both"},
\code{"equivalence"}, or \code{"="}). See the special section below for
more details.}

\item{...}{Not used by \code{summary.emmGrid} or \code{predict.emmGrid}. In
\code{confint.emmGrid} and \code{test.emmGrid}, these arguments are passed to
\code{summary.emmGrid}.}

\item{parm}{(Required argument for \code{confint} methods, but not used)}

\item{joint}{Logical value. If \code{FALSE}, the arguments are passed to 
\code{\link{summary.emmGrid}} with \code{infer=c(FALSE, TRUE)}. If \code{joint = 
TRUE}, a joint test of the hypothesis L beta = null is performed, where L 
is \code{object@linfct} and beta is the vector of fixed effects estimated 
by \code{object@betahat}. This will be either an \emph{F} test or a 
chi-square (Wald) test depending on whether degrees of freedom are 
available.}

\item{verbose}{Logical value. If \code{TRUE} and \code{joint = TRUE}, a table
of the effects being tested is printed.}

\item{rows}{Integer values. The rows of L to be tested in the joint test. If
missing, all rows of L are used. If not missing, \code{by} variables are
ignored.}
}
\value{
\code{summary.emmGrid}, \code{confint.emmGrid}, and \code{test.emmGrid} return an
  object of class \code{"summary_emm"}, which is an extension of
  \code{\link{data.frame}} but with a special \code{print} method that with
  custom formatting. For models fitted using MCMC methods, the result is
  typically a frequentist summary, based on the empirical mean and covariance
  matrix of the \code{post.beta} slot. A Bayesian summary may be obtained
  using \code{\link{as.mcmc.emmGrid}} and summarizing that result using tools for
  Bayesian estimation.

\code{predict} returns a vector of predictions for each row of \code{object@grid}.
}
\description{
These are the primary methods for obtaining numerical or tabular results 
from an \code{emmGrid} object.
}
\details{
\code{summary.emmGrid} is the general function for summarizing \code{emmGrid} objects. 
\code{confint.emmGrid} is equivalent to \code{summary.emmGrid with 
infer = c(TRUE, FALSE)}. When called with \code{joint = FALSE}, \code{test.emmGrid}
is equivalent to \code{summary.emmGrid} with \code{infer = c(FALSE, TRUE)}.

With \code{joint = TRUE}, \code{test.emmGrid} calculates the Wald test of the
hypothesis \code{linfct \%*\% bhat = null}, where \code{linfct} and
\code{bhat} refer to slots in \code{object} (possibly subsetted according to
\code{by} or \code{rows}). An error is thrown if any row of \code{linfct} is
non-estimable. It is permissible for the rows of \code{linfct} to be linearly
dependent, as long as \code{null == 0}, in which case a reduced set of 
contrasts is tested. Linear dependence and nonzero \code{null} cause an 
error.
}
\note{
In doing testing and a transformation and/or link is in force, any
  \code{null} and/or \code{delta} values specified must always be on the
  scale of the linear predictor, regardless of the setting for `type`. If
  \code{type = "response"}, the null value displayed in the summary table 
  will be back-transformed from the value supplied by the user. But the
  displayed \code{delta} will not be changed, because there (usually) is
  not a natural way to back-transform it.

The default \code{show} method for \code{emmGrid} objects (with the
  exception of newly created reference grids) is \code{print(summary())}.
  Thus, with ordinary usage of \code{\link{emmeans}} and such, it is
  unnecessary to call \code{summary} unless there is a need to
  specify other than its default options.
}
\section{Testing nonsuperiority, noninferiority, or equivalence}{

When \code{delta = 0}, test statistics are of the usual form \samp{(estimate
- null)/SE}, or notationally, \eqn{t = (Q - \theta_0)/SE} where \eqn{Q} is
our estimate of \eqn{\theta}; then left, right, or two-sided \eqn{p} values
are produced.

When \code{delta} is positive, the test statistic depends on \code{side} as
follows.
\describe{
\item{Left-sided (nonsuperiority)}{\eqn{H_0: \theta \ge \theta_0 + \delta}
  versus \eqn{H_1: \theta < \theta_0 + \delta}\cr 
  \eqn{t = (Q - \theta_0 - \delta)/SE}\cr 
  The \eqn{p} value is the lower-tail probability.}
\item{Right-sided (noninferiority)}{\eqn{H_0: \theta \le \theta_0 - \delta}
  versus \eqn{H_1: \theta > \theta_0 - \delta}\cr 
  \eqn{t = (Q - \theta_0 + \delta)/SE}\cr
  The \eqn{p} value is the upper-tail probability.}
\item{Two-sided (equivalence)}{\eqn{H_0: |\theta - \theta_0| \ge \delta}
  versus \eqn{H_1: |\theta - \theta_0| < \delta}\cr
  \eqn{t = (|Q - \theta_0| - \delta)/SE}\cr
  The \eqn{p} value is the \emph{lower}-tail probability.}
}
}

\examples{
warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)
warp.emmGrid <- emmeans(warp.lm, ~ tension | wool)
warp.emmGrid    # implicitly runs 'summary'

confint(warp.emmGrid, by = NULL, level = .90)

# --------------------------------------------------------------
pigs.lm <- lm(log(conc) ~ source + factor(percent), data = pigs)
pigs.emmGrid <- emmeans(pigs.lm, "percent", type = "response")
summary(pigs.emmGrid)    # (inherits type = "response")

# For which percents is EMM non-inferior to 35, based on a 10\% threshold?
# Note the test is done on the log scale even though we have type = "response"
test(pigs.emmGrid, null = log(35), delta = log(1.10), side = ">")

test(contrast(pigs.emmGrid, "consec"))

test(contrast(pigs.emmGrid, "consec"), joint = TRUE)

}
