% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{oranges}
\alias{oranges}
\title{Sales of oranges}
\format{A data frame with 36 observations and 6 variables:
\describe{
  \item{\code{store}}{a factor with levels \code{1} \code{2} \code{3}
    \code{4} \code{5} \code{6}. The store that was observed.}
  \item{\code{day}}{a factor with levels \code{1} \code{2} \code{3}
    \code{4} \code{5} \code{6}. The day the observation was taken (same for
    each store).}
  \item{\code{price1}}{a numeric vector. Price of variety 1.}
  \item{\code{price2}}{a numeric vector. Price of variety 2.}
  \item{\code{sales1}}{a numeric vector. Sales (per customer) of variety 1.}
  \item{\code{sales2}}{a numeric vector. Sales (per customer) of variety 2.}
}}
\source{
SAS sample dataset. Download from \url{http://ftp.sas.com/samples/A56655}.
}
\usage{
oranges
}
\description{
This example dataset on sales of oranges has two factors, two covariates, and
two responses. There is one observation per factor combination.
}
\examples{
# Example on p.244 of Littell et al.
oranges.lm <- lm(sales1 ~ price1*day, data = oranges)
emmeans(oranges.lm, "day")

# Example on p.246 of Littell et al.
emmeans(oranges.lm, "day", at = list(price1 = 0))

# A more sensible model to consider, IMHO (see vignette("interactions"))
org.mlm <- lm(cbind(sales1, sales2) ~ price1 * price2 + day + store, 
              data = oranges)
}
\references{
Littell, R., Stroup W., Freund, R. (2002) \emph{SAS For Linear Models} (4th
edition). SAS Institute. ISBN 1-59047-023-0.
}
\keyword{datasets}
