% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCRS.r
\name{getCRS}
\alias{getCRS}
\title{WKT string for a named coordinate reference system or a spatial object}
\usage{
getCRS(x = NULL, nice = FALSE, warn = TRUE)
}
\arguments{
\item{x}{This can be any of:
\itemize{
    \item Name of CRS: Each CRS has one "long" name and at least one "short" name, which appear in the table returned by \code{getCRS()}. You can use the "long" name of the CRS, or either of the two "short" names.  Spaces, case, and dashes are ignored, but to make the codes more memorable, they are shown as having them.
        \item \code{NULL} (default): This returns a table of projections with their "long" and "short" names (nearly the same as \code{data(crss)}).
    \item An object of class \code{SpatVector}, \code{SpatRaster}, or \code{sf}. If this is a "\code{Spat}" object, then a character vector with the CRS in WKT form is returned. If a \code{sf} is supplied, then a \code{crs} object is returned in WKT format.
}}

\item{nice}{If \code{TRUE}, then print the CRS in a formatted manner and return it invisibly. Default is \code{FALSE}.}

\item{warn}{If \code{TRUE} (default), then print a warning if the name of the CRS cannot be found.}
}
\value{
A string representing WKT2 (well-known text) object or a \code{data.frame}.
}
\description{
Retrieve the Well-Known text string (WKT2) for a coordinate reference system (CRS) by name or from a spatial object. The most common usage of the function is to return the WKT2 string using an easy-to-remember name. For example, \code{getCRS('wgs84')} returns the WKT2 string for the WGS84 datum. To get a table of strings, just use \code{getCRS()}.
}
\examples{

# view table of available CRSs
getCRS()

# get specific WKT2 strings
getCRS('WGS84')
getCRS('Mollweide')
getCRS('WorldClim')

# WKT2 strings nice for your eyes
getCRS('WGS84', TRUE)

data(mad0)
getCRS(mad0)

}
