% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_curve.R
\name{response_curve}
\alias{response_curve}
\title{Variable response curves for GLMs}
\usage{
response_curve(fitted, variable, n = 100, new_data = NULL, extrapolate = TRUE,
               xlab = NULL, ylab = "Probability", col = "red", ...)
}
\arguments{
\item{fitted}{an object of class \code{glm} or a list of GLMs obtained using the
functions \code{\link{fit_selected}} or \code{\link{fit_glms}}.}

\item{variable}{(character) name of the variables to be plotted.}

\item{n}{(numeric) an integer guiding the number of breaks. Default = 100}

\item{new_data}{a \code{SpatRaster}, data.frame, or  matrix of variables
representing the range of variable values in an area of interest.
Default = NULL.}

\item{extrapolate}{(logical) whether to allow extrapolation to study the
behavior of the response outside the calibration limits. Ignored if
\code{new_data} is defined. Default = TRUE.}

\item{xlab}{(character) a label for the x axis. The default, NULL, uses the
name defined in \code{variable}.}

\item{ylab}{(character) a label for the y axis. Default = "Probability".}

\item{col}{(character) color for lines. Default = "red".}

\item{...}{additional arguments passed to \code{\link[graphics]{plot}}.}
}
\value{
A plot with the response curve for a \code{variable}.
}
\description{
A view of variable responses in models. Responses based on single or multiple
models can be provided.
}
\details{
The function calculates these probabilities by focusing on a single
environmental variable while keeping all other variables constant at their
mean values.

When responses for multiple models are to be plotted, the mean and confidence
intervals for the set of responses are calculated using a GAM.
}
\examples{
# Load a fitted selected model
data(sel_fit, package = "enmpa")

# Response curve for single models
response_curve(sel_fit$ModelID_7, variable = "bio_1")

# Response curve when model(s) are in a list (only one model in this one)
response_curve(sel_fit, variable = "bio_12")
}
