% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enspls.od.R
\name{enspls.od}
\alias{enspls.od}
\title{Ensemble Sparse Partial Least Squares for Outlier Detection}
\usage{
enspls.od(x, y, maxcomp = 5L, cvfolds = 5L, alpha = seq(0.2, 0.8, 0.2),
  reptimes = 500L, method = c("mc", "boot"), ratio = 0.8, parallel = 1L)
}
\arguments{
\item{x}{Predictor matrix.}

\item{y}{Response vector.}

\item{maxcomp}{Maximum number of components included within each model.
If not specified, will use \code{5} by default.}

\item{cvfolds}{Number of cross-validation folds used in each model
for automatic parameter selection, default is \code{5}.}

\item{alpha}{Parameter (grid) controlling sparsity of the model.
If not specified, default is \code{seq(0.2, 0.8, 0.2)}.}

\item{reptimes}{Number of models to build with Monte-Carlo resampling
or bootstrapping.}

\item{method}{Resampling method. \code{"mc"} (Monte-Carlo resampling)
or \code{"boot"} (bootstrapping). Default is \code{"mc"}.}

\item{ratio}{Sampling ratio used when \code{method = "mc"}.}

\item{parallel}{Integer. Number of CPU cores to use.
Default is \code{1} (not parallelized).}
}
\value{
A list containing four components:
\itemize{
\item \code{error.mean} - error mean for all samples (absolute value)
\item \code{error.median} - error median for all samples
\item \code{error.sd} - error sd for all samples
\item \code{predict.error.matrix} - the original prediction error matrix
}
}
\description{
Outlier detection with ensemble sparse partial least squares.
}
\note{
To maximize the probablity that each observation can
be selected in the test set (thus the prediction uncertainty
can be measured), please try setting a large \code{reptimes}.
}
\examples{
data("logd1k")
x = logd1k$x
y = logd1k$y

set.seed(42)
od = enspls.od(
  x, y, reptimes = 5, maxcomp = 3,
  alpha = c(0.3, 0.6, 0.9))
plot(od, prob = 0.1)
plot(od, criterion = "sd", sdtimes = 1)
}
\seealso{
See \code{\link{enspls.fs}} for measuring feature importance
with ensemble sparse partial least squares regressions.
See \code{\link{enspls.fit}} for fitting ensemble sparse
partial least squares regression models.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
