% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.enpls.R
\name{plot.enpls.ad}
\alias{plot.enpls.ad}
\title{Plot enpls.ad object}
\usage{
\method{plot}{enpls.ad}(x, type = c("static", "interactive"), main = NULL,
  ...)
}
\arguments{
\item{x}{An object of class \code{enpls.ad}.}

\item{type}{Plot type. Can be \code{"static"} or \code{"interactive"}.}

\item{main}{Plot title, not used currently.}

\item{...}{Additional graphical parameters, not used currently.}
}
\description{
Plot enpls.ad object
}
\examples{
data("alkanes")
x = alkanes$x
y = alkanes$y

# training set
x.tr = x[1:100, ]
y.tr = y[1:100]

# two test sets
x.te = list(
  "test.1" = x[101:150, ],
  "test.2" = x[151:207, ])
y.te = list(
  "test.1" = y[101:150],
  "test.2" = y[151:207])

set.seed(42)
ad = enpls.ad(
  x.tr, y.tr, x.te, y.te,
  space = "variable", method = "mc",
  ratio = 0.9, reptimes = 50)
plot(ad)
# the interactive plot requires a HTML viewer
\dontrun{
plot(ad, type = "interactive")}
}
\seealso{
See \code{\link{enpls.ad}} for model applicability domain
evaluation with ensemble partial least squares regressions.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
