\name{trainingData}
\alias{trainingData}
\title{
    Training data for a given date and training rule.
}
\description{
  Extracts the training data corresponding to a given date and training rule.
}
\usage{
trainingData( ensembleData, date, trainingRule = list(length=30, lag=2)) 
}
\arguments{
  \item{ensembleData}{
     An \code{ensembleData} object including ensemble forecasts, observations 
     and dates of precipitation. 
  }
  \item{date}{
     The date for which the training data is desired. 
  }
  \item{trainingRule}{
     A list giving the \code{length} and \code{lag} for the training period.
     The default is to use a 30 day training period for a forecast
     2 days ahead of the last day in the training period.
  }
}
\value{
An \code{ensembleData} object corresponding to the training data for
the given date relative to \code{ensembleData}.
}
\details{
  The training rule uses the most recent days for the given period
  regardless of whether or not they are consecutive.
}
\seealso{
  \code{\link{ensembleBMA}}, 
  \code{\link{fitBMA}} 
}

\references{
A. E. Raftery, T. Gneiting, F. Balabdaoui and M. Polakowski,
Using Bayesian Model Averaging to Calibrate Forecast Ensembles,
\emph{Monthly Weather Review 133:1155-1174, 2005}.

J. M. Sloughter, A. E. Raftery, T. Gneiting and C. Fraley, 
Probabilistic Quantitative Precipitation Forecasting 
using Bayesian Model Averaging,
Technical Report No. 496R, Department of Statistics, University of
Washington, October 2006 (to appear in \emph{Montly Weather Review}).
}

\examples{
\dontrun{
  data(slp)

  slpData <- ensembleData(forecasts = slp[c("AVN","GEM","ETA","NGM","NOGAPS")],
                          observations = slp$obs, dates = slp$date)

  trainDat <- trainingData(slpData, date = "2000063000",
                           trainingRule = list(length=30,lag =2))
 
  slpFitTD <- fitBMAnormal(trainDat)
}
}
\keyword{models}
% docclass is function
