% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getComponents}
\alias{getComponents}
\title{Get phenotypic components.}
\usage{
getComponents(pop)
}
\arguments{
\item{pop}{a \code{Population} object}
}
\value{
Returns a \code{data.frame} giving the individual's ID,
the ID of the sire, the ID of the dam, the additive, epistatic and
environmental components of the phenotype and the overall
phenotypic value.
}
\description{
Get pedigree and phenotypic data from current population.
}
\details{
Retrieves the pedigree and phenotypic data components from all
individuals in the current population.
}
\examples{
# Construct a population with additive and epistatic effects
pop <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.9, narrowh2 = 0.6, traitVar = 40
)
pop <- addEffects(pop)
pop <- attachEpiNet(pop)

# Retrieve phenotypic components from population
components <- getComponents(pop)
}
\seealso{
\code{\link{Population}}, \code{\link{addEffects}},
  \code{\link{attachEpiNet}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
