% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_owas.R
\name{volcano_owas}
\alias{volcano_owas}
\title{Create volcano plot using results from owas}
\usage{
volcano_owas(
  df,
  annotate_ftrs = TRUE,
  annotation_p_threshold = 0.05,
  highlight_adj_p = TRUE,
  highlight_adj_p_threshold = 0.05,
  horizontal_line_p_value = 0.05
)
}
\arguments{
\item{df}{output from \code{owas} function call}

\item{annotate_ftrs}{Should features be annotated with the feature name?
Default is TRUE. If necessary can change the p_value_threshold as well.}

\item{annotation_p_threshold}{If \code{annotate_ftrs} = TRUE, can set
annotation_p_threshold to change the p-value threshold for which features
will be annotated. Defaults to 0.05.}

\item{highlight_adj_p}{Should features which meet a specific adjusted p-value
threshold be highlighted? Default is TRUE.}

\item{highlight_adj_p_threshold}{If \code{highlight_adj_p} = TRUE, can set
annotation_adj_p_threshold to change the adjusted p-value threshold for
which features will be highlighted. Defaults to 0.05.}

\item{horizontal_line_p_value}{Set the p-value for the horizontal line
for the threshold of significance.}
}
\value{
A ggplot figure
}
\description{
Creates a volcano plot based on ggplot using the results from the
\code{owas} function.
}
\examples{
data("example_data")

# Get names of omics
colnames_omic_fts <- colnames(example_data)[
  grep("feature_",
       colnames(example_data))][1:5]

# Run function with continuous exposure as the variable of interest
owas_out <- owas(df = example_data,
                 var = "exposure1",
                 omics = colnames_omic_fts,
                 covars = c("age", "sex"),
                 var_exposure_or_outcome = "exposure",
                 family = "gaussian")

vp <- volcano_owas(owas_out)

}
