% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk.R
\name{risk}
\alias{risk}
\title{Calculate risk ratio and risk difference}
\usage{
risk(data, exposure, outcome, ci_level = 95)
}
\arguments{
\item{data}{A dataframe}

\item{exposure}{Variable giving the levels of the outcome}

\item{outcome}{Variable giving cases (1) or non-cases (0)}

\item{ci_level}{a string giving the confidence interval}
}
\value{
A dataframe with the risk ratio, risk difference and confidence intervals
}
\description{
Calculate risk ratios and risk differences
}
\examples{
# Data from stratum 1 of table 15-1., p260
dat <- data.frame(
    exposure_var = c(rep(1, 8), rep(0, 5), rep(1, 98), rep(0, 115)),
  outcome_var = c(rep(1, 8), rep(1, 5), rep(0, 98), rep(0, 115)),
  stringsAsFactors = FALSE
)
risk(data = dat, exposure = exposure_var, outcome = outcome_var)
}
