% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdd.R
\name{read_rdd}
\alias{read_rdd}
\alias{read_mdd}
\title{Read an EnergyPlus Report Data Dictionary File}
\usage{
read_rdd(path)

read_mdd(path)
}
\arguments{
\item{path}{For \code{read_rdd()}, a file path of EnergyPlus EnergyPlus Report Data
Dictionary file with an extension \code{.rdd}. For \code{read_mdd()}, a file path of
EnergyPlus EnergyPlus Meter Data Dictionary file with an extension \code{.mdd}}
}
\value{
For \code{read_rdd()}, an \code{RddFile} object. For \code{read_mdd()}, a \code{MddFile}
object.
}
\description{
\code{read_rdd()} takes a file path of EnergyPlus Report Data Dictionary (RDD)
file, parses it and returns a \code{RddFile} object. \code{read_mdd()} takes a file
path of EnergyPlus Meter Data Dictionary (MDD) file, parses it and returns a
\code{MddFile} object.
}
\details{
Basically, a \code{RddFile} and \code{MddFile} object is a
\link[data.table:data.table]{data.table} with 3 additional attributes:
\itemize{
\item \code{eplus_version}: A \link[base:numeric_version]{numeric_version} object. The
version of EnergyPlus used during the simulation.
\item \code{eplus_build}: A single string. The build tag of EnergyPlus used during the
simulation.
\item \code{datetime}: A DateTime (POSIXct). The time when the simulation started.
}
}
\examples{
\dontrun{
# run simulation and get the err file
idf_name <- "1ZoneUncontrolled.idf"
epw_name <-  "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw"
idf_path <- file.path(eplus_config(8.8)$dir, "ExampleFiles", idf_name)
epw_path <- file.path(eplus_config(8.8)$dir, "WeatherData", epw_name)
job <- eplus_job(idf_path, epw_path)

# read the err file
read_rdd(job$locate_output(".rdd"))
read_mdd(job$locate_output(".mdd"))
}
}
\author{
Hongyuan Jia
}
