% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqMI.covtest.R
\name{eqMI.covtest}
\alias{eqMI.covtest}
\title{Test the equality of two covariance matrices in population}
\usage{
eqMI.covtest(..., lamb0 = NULL)
}
\arguments{
\item{...}{The same arguments as for any lavaan model. See \code{lavaan::sem} for more information.}

\item{lamb0}{initial coefficients of Lagrange multiplier. If not pre-specified, 0.01 will be used.}
}
\value{
The likelihood ratio statistic, degrees of freedom, and p-value of the test.
}
\description{
The first step of testing measurement invariance (MI) in multiple-group SEM analysis. The null hypothesis is tested using the method of Lagrange multipliers
}
\details{
The \code{eqMI.covtest} function is the first step to test MI. Under null hypothesis testing (NHT), a non-significant statistic is generally an overall endorsement of MI. If the null hypothesis is rejected then one may proceed to test other aspects of MI.
}
\examples{
data(HolzingerSwineford)
semmodel<-'
L1 =~ V1 + V2 + V3
L2 =~ V4 + V5 + V6
L3 =~ V7 + V8
L4 =~ V9 + V10 + V11
'
cov.test <- eqMI.covtest(model = semmodel,
                         data = HolzingerSwineford,
                         group="school")

}
\references{
Yuan, K. H., & Chan, W. (2016). Measurement invariance via multigroup SEM: Issues and solutions with chi-square-difference tests. Psychological methods, 21(3), 405-426.

Yves Rosseel (2012). lavaan: An R Package for Structural Equation Modeling. Journal of Statistical Software, 48(2), 1-36. URL http://www.jstatsoft.org/v48/i02/.
}
