% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/era.R
\name{era}
\alias{era}
\title{Create an era object}
\usage{
era(
  label,
  epoch = NULL,
  name = label,
  unit = era_year("Gregorian"),
  scale = 1,
  direction = -1
)
}
\arguments{
\item{label}{Character. If only one argument is given to \code{era()}, the
abbreviated label of a standard era defined in \code{\link[=eras]{eras()}}.
Otherwise, the label to give to the era constructed using the following
arguments.}

\item{epoch}{Integer. Epoch year from which years are counted (in the Common
Era).}

\item{name}{Character. Full name of the era. Defaults to the value of
\code{label}.}

\item{unit}{An \code{\link[=era_year]{era_year()}} object describing the name of the year unit and
its average length in solar days. Defaults to a Gregorian year
(365.2425 days).}

\item{scale}{Integer. Number of years represented by one unit, e.g. \code{1000}
for ka. Default: 1.}

\item{direction}{Are years counted backwards (\code{-1}) (the default) or forwards (\code{1})
from \code{epoch}?}
}
\value{
An object of class \code{era}.
}
\description{
An \code{era} object defines the time scale associated with a vector of years
(see \code{\link[=yr]{yr()}}). \code{era()} returns an \code{era} object, either by looking up
\code{label} in the standard eras defined in \code{\link[=eras]{eras()}} or, if more than one
argument is given, constructing a new definition with the specified
parameters.
}
\examples{
era("cal BP")

era("T.A.", epoch = -9021, name = "Third Age", direction = 1)
}
\seealso{
Other era definition functions: 
\code{\link{eras}()}

Other era helper functions: 
\code{\link{era_parameters}},
\code{\link{era_year_parameters}},
\code{\link{era_year}()},
\code{\link{is_era_year}()},
\code{\link{is_era}()},
\code{\link{is_yr}()},
\code{\link{this_year}()}
}
\concept{era definition functions}
\concept{era helper functions}
