% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.san.R
\name{san}
\alias{san}
\alias{san.default}
\alias{san.formula}
\alias{san.ergm_model}
\alias{san.ergm}
\title{Use Simulated Annealing to attempt to match a network to a vector of mean
statistics}
\usage{
san(object, ...)

\method{san}{formula}(object, response = NULL, reference = ~Bernoulli,
  constraints = ~., target.stats = NULL, nsim = NULL, basis = NULL,
  output = c("network", "edgelist", "pending_update_network"),
  only.last = TRUE, control = control.san(), verbose = FALSE, ...)

\method{san}{ergm_model}(object, response = NULL,
  reference = ~Bernoulli, constraints = ~., target.stats = NULL,
  nsim = NULL, basis = NULL, output = c("network", "edgelist",
  "pending_update_network"), only.last = TRUE, control = control.san(),
  verbose = FALSE, ...)

\method{san}{ergm}(object, formula = object$formula,
  constraints = object$constraints, target.stats = object$target.stats,
  nsim = NULL, basis = NULL, output = c("network", "edgelist",
  "pending_update_network"), only.last = TRUE,
  control = object$control$SAN.control, verbose = FALSE, ...)
}
\arguments{
\item{object}{Either a \code{\link{formula}} or an \code{\link{ergm}} object. The
\code{\link{formula}} should be of the form \code{y ~ <model terms>}, where
\code{y} is a network object or a matrix that can be coerced to a
\code{\link{network}} object.  For the details on the
possible \code{<model terms>}, see \code{\link{ergm-terms}}.  To
create a \code{\link[network]{network}} object in , use the
\code{network()} function, then add nodal attributes to it using
the \code{\%v\%} operator if necessary.}

\item{\dots}{Further arguments passed to other functions.}

\item{response}{Name of the edge attribute whose value
is to be modeled. Defaults to \code{NULL} for simple presence or absence.}

\item{reference}{One-sided formula whose RHS gives the
reference measure to be used. (Defaults to \code{~Bernoulli}.)}

\item{constraints}{A one-sided formula specifying one or more constraints on
the support of the distribution of the networks being simulated. See the
documentation for a similar argument for \code{\link{ergm}} and see
\link[=ergm-constraints]{list of implemented constraints} for more information. For
\code{simulate.formula}, defaults to no constraints. For
\code{simulate.ergm}, defaults to using the same constraints as those with
which \code{object} was fitted.}

\item{target.stats}{A vector of the same length as the number of terms
implied by the formula, which is either \code{object} itself in the case of
\code{san.formula} or \code{object$formula} in the case of \code{san.ergm}.}

\item{nsim}{Number of networks to generate. Deprecated: just use \code{\link[=replicate]{replicate()}}.}

\item{basis}{If not NULL, a \code{network} object used to start the Markov
chain.  If NULL, this is taken to be the network named in the formula.}

\item{output}{Character, one of \code{"network"} (default),
\code{"edgelist"}, or \code{"pending_update_network"}: determines the
output format. Partial matching is performed.}

\item{only.last}{if \code{TRUE}, only return the last network generated;
otherwise, return a \code{\link{network.list}} with \code{nsim} networks.}

\item{control}{A list of control parameters for algorithm tuning; see
\code{\link{control.san}}.}

\item{verbose}{Logical or numeric giving the level of verbosity. Higher values produce more verbose output.}

\item{formula}{(By default, the \code{formula} is taken from the \code{ergm}
object.  If a different \code{formula} object is wanted, specify it here.}
}
\value{
A network or list of networks that hopefully have network
statistics close to the \code{target.stats} vector.
}
\description{
This function attempts to find a network or networks whose statistics match
those passed in via the \code{target.stats} vector.
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: Sufficient statistics are specified by a \code{\link{formula}}.

\item \code{ergm_model}: A lower-level function that expects a pre-initialized \code{\link{ergm_model}}.

\item \code{ergm}: Sufficient statistics and other settings are
inherited from the \code{\link{ergm}} fit unless overridden.
}}

\examples{
\donttest{
# initialize x to a random undirected network with 50 nodes and a density of 0.1
x <- network(50, density = 0.05, directed = FALSE)
 
# try to find a network on 50 nodes with 300 edges, 150 triangles,
# and 1250 4-cycles, starting from the network x
y <- san(x ~ edges + triangles + cycle(4), target.stats = c(300, 150, 1250))

# check results
summary(y ~ edges + triangles + cycle(4))

# initialize x to a random directed network with 50 nodes
x <- network(50)

# add vertex attributes
x \%v\% 'give' <- runif(50, 0, 1)
x \%v\% 'take' <- runif(50, 0, 1)

# try to find a set of 100 directed edges making the outward sum of
# 'give' and the inward sum of 'take' both equal to 62.5, so in
# edges (i,j) the node i tends to have above average 'give' and j
# tends to have above average 'take'
y <- san(x ~ edges + nodeocov('give') + nodeicov('take'), target.stats = c(100, 62.5, 62.5))

# check results
summary(y ~ edges + nodeocov('give') + nodeicov('take'))


# initialize x to a random undirected network with 50 nodes
x <- network(50, directed = FALSE)

# add a vertex attribute
x \%v\% 'popularity' <- runif(50, 0, 1)

# try to find a set of 100 edges making the total sum of
# popularity(i) and popularity(j) over all edges (i,j) equal to
# 125, so nodes with higher popularity are more likely to be
# connected to other nodes
y <- san(x ~ edges + nodecov('popularity'), target.stats = c(100, 125))
 
# check results
summary(y ~ edges + nodecov('popularity'))

# creates a network with denser "core" spreading out to sparser
# "periphery"
plot(y)
}
}
\keyword{models}
