% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.update.R
\name{update.network}
\alias{update.network}
\alias{update_network}
\alias{update_network.matrix_edgelist}
\alias{update_network.data.frame}
\alias{update_network.matrix}
\alias{update_network.ergm_state}
\title{Update the edges in a network based on a matrix}
\usage{
\method{update}{network}(object, ...)

update_network(object, new, ...)

\method{update_network}{matrix_edgelist}(object, new, attrname = if (ncol(new) > 2) names(new)[3], ...)

\method{update_network}{data.frame}(object, new, attrname = if (ncol(new) > 2) names(new)[3], ...)

\method{update_network}{matrix}(object, new, matrix.type = NULL, attrname = NULL, ...)

\method{update_network}{ergm_state}(object, new, ...)
}
\arguments{
\item{object}{a \code{\link{network}} object.}

\item{\dots}{Additional arguments; currently unused.}

\item{new}{Either an adjacency matrix (a matrix of values
indicating the presence and/or the value of a tie from i to j) or
an edge list (a two-column matrix listing origin and destination
node numbers for each edge, with an optional third column for the
value of the edge).}

\item{attrname}{For a network with edge weights gives the name of
the edge attribute whose names to set.}

\item{matrix.type}{One of \code{"adjacency"} or \code{"edgelist"} telling
which type of matrix \code{new} is.  Default is to use the
\code{\link[network]{which.matrix.type}} function.}
}
\value{
A new \code{\link{network}} object with the edges specified by
\code{new} and network and vertex attributes copied from
the input network \code{object}. Input network is not modified.
}
\description{
Replaces the edges in a \code{\link{network}} object with the edges corresponding
to the sociomatrix or edge list specified by \code{new}.
}
\section{Functions}{
\itemize{
\item \code{update_network}: dispatcher for network update based on the type of updating information.

\item \code{update_network.matrix_edgelist}: a method for updating a network based on a matrix-form edgelist

\item \code{update_network.data.frame}: a method for updating a network based on an edgelist

\item \code{update_network.matrix}: a method for updating a network based on a matrix

\item \code{update_network.ergm_state}: a method for updating a network based on an \code{\link{ergm_state}} object.
}}

\examples{

#
data(florentine)
#
# test the network.update function
#
# Create a Bernoulli network
rand.net <- network(network.size(flomarriage))
# store the sociomatrix 
rand.mat <- rand.net[,]
# Update the network
update(flomarriage, rand.mat, matrix.type="adjacency")
# Try this with an edgelist
rand.mat <- as.matrix.network.edgelist(flomarriage)[1:5,]
update(flomarriage, rand.mat, matrix.type="edgelist")

}
\seealso{
\code{\link[=ergm]{ergm()}}, \code{\link{network}}
}
\keyword{models}
