% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{nvertex}
\alias{nvertex}
\alias{nedges}
\alias{nedges.network}
\alias{nedges.list}
\alias{nedges.matrix}
\alias{nedges.ergmito}
\alias{nedges.formula}
\alias{nvertex.network}
\alias{nvertex.matrix}
\alias{nvertex.list}
\alias{nvertex.ergmito}
\alias{nvertex.formula}
\alias{nnets}
\alias{nnets.list}
\alias{nnets.matrix}
\alias{nnets.network}
\alias{nnets.ergmito}
\alias{nnets.formula}
\alias{is_directed}
\alias{is_directed.network}
\alias{is_directed.list}
\alias{is_directed.default}
\alias{is_directed.ergmito}
\alias{is_directed.formula}
\title{Utility functions to query network dimensions}
\usage{
nvertex(x)

nedges(x, ...)

\method{nedges}{network}(x, ...)

\method{nedges}{list}(x, ...)

\method{nedges}{matrix}(x, ...)

\method{nedges}{ergmito}(x, ...)

\method{nedges}{formula}(x, ...)

\method{nvertex}{network}(x)

\method{nvertex}{matrix}(x)

\method{nvertex}{list}(x)

\method{nvertex}{ergmito}(x)

\method{nvertex}{formula}(x)

nnets(x)

\method{nnets}{list}(x)

\method{nnets}{matrix}(x)

\method{nnets}{network}(x)

\method{nnets}{ergmito}(x)

\method{nnets}{formula}(x)

is_directed(x, check_type = FALSE)

\method{is_directed}{network}(x, check_type = FALSE)

\method{is_directed}{list}(x, check_type = FALSE)

\method{is_directed}{default}(x, check_type = FALSE)

\method{is_directed}{ergmito}(x, check_type = FALSE)

\method{is_directed}{formula}(x, check_type = FALSE)
}
\arguments{
\item{x}{Either an object of class \link{ergmito}, \link{network}, \link{formula}, or \link{matrix}.}

\item{...}{Further arguments passed to the method. Currently only \code{nedges.network}
receives arguments (see \link[network:network.edgecount]{network::network.edgecount}).}

\item{check_type}{Logical scalar. When checking for whether the network is
directed or not, we can ask the function to return with an error if what we
are checking is not an object of class network, otherwise it simply returns
false.}
}
\value{
\code{is_directed} checks whether the passed networks are directed using
the function \link[network:is.directed]{network::is.directed}. In the case of multiple networks,
the function returns a logical vector. Only objects of class \code{network} can be
checked, otherwise, if \code{check_type = FALSE}, the function returns \code{TRUE} by default.
}
\description{
Utility functions to query network dimensions
}
\examples{
set.seed(771)
net <- lapply(rbernoulli(c(4, 4)), network::network, directed = FALSE)
is_directed(net)
is_directed(net[[1]])
is_directed(net ~ edges)
\dontrun{
  is_directed(net[[1]][1:4, 1:4], check_type = TRUE) # Error
}
is_directed(net[[1]][1:4, 1:4])
}
