% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mdiff_2x2_between.R
\name{estimate_mdiff_2x2_between}
\alias{estimate_mdiff_2x2_between}
\title{Estimates for a 2x2 between-subjects design with a continuous outcome
variable}
\usage{
estimate_mdiff_2x2_between(
  data = NULL,
  outcome_variable = NULL,
  grouping_variable_A = NULL,
  grouping_variable_B = NULL,
  means = NULL,
  sds = NULL,
  ns = NULL,
  grouping_variable_A_levels = NULL,
  grouping_variable_B_levels = NULL,
  outcome_variable_name = "My outcome variable",
  grouping_variable_A_name = "A",
  grouping_variable_B_name = "A",
  conf_level = 0.95,
  assume_equal_variance = FALSE,
  save_raw_data = TRUE
)
}
\arguments{
\item{data}{For raw data - a data frame or tibble}

\item{outcome_variable}{For raw data - The column name of the outcome
variable, or a vector of numeric data}

\item{grouping_variable_A}{For raw data - The column name of the grouping
variable, or a vector of group names, only 2 levels allowed}

\item{grouping_variable_B}{For raw data - The column name of the grouping
variable, or a vector of group names, only 2 levels allowed}

\item{means}{For summary data - A vector of 4 means: A1B1, A1B2, A2B1, A2B2}

\item{sds}{For summary data - A vector of 4 standard deviations, same order}

\item{ns}{For summary data - A vector of 4 sample sizes}

\item{grouping_variable_A_levels}{For summary data - An optional vector of
2 group labels}

\item{grouping_variable_B_levels}{For summary data - An optional vector of
2 group labels}

\item{outcome_variable_name}{Optional friendly name for the outcome variable.
Defaults to 'My outcome variable' or the outcome variable column name if a
data frame is passed.}

\item{grouping_variable_A_name}{Optional friendly name for the grouping
variable.  Defaults to 'A' or the grouping variable
column name if a data.frame is passed.}

\item{grouping_variable_B_name}{Optional friendly name for the grouping
variable.  Defaults to 'A' or the grouping variable
column name if a data.frame is passed.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{assume_equal_variance}{Defaults to FALSE}

\item{save_raw_data}{For raw data; defaults to TRUE; set to FALSE to save
memory by not returning raw data in estimate object}
}
\value{
Returns object of class esci_estimate
\itemize{
\item \strong{es_mean_difference}
\itemize{
\item \emph{type} -
\item \emph{outcome_variable_name} -
\item \emph{grouping_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{df} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
\item \emph{effect_type} -
\item \emph{effects_complex} -
}
\item \strong{es_median_difference}
\itemize{
\item \emph{type} -
\item \emph{outcome_variable_name} -
\item \emph{grouping_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
\item \emph{effect_type} -
\item \emph{effects_complex} -
}
\item \strong{es_smd}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{grouping_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{numerator} -
\item \emph{denominator} -
\item \emph{SE} -
\item \emph{df} -
\item \emph{d_biased} -
\item \emph{effect_type} -
\item \emph{effects_complex} -
}
\item \strong{overview}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{grouping_variable_name} -
\item \emph{grouping_variable_level} -
\item \emph{mean} -
\item \emph{mean_LL} -
\item \emph{mean_UL} -
\item \emph{median} -
\item \emph{median_LL} -
\item \emph{median_UL} -
\item \emph{sd} -
\item \emph{min} -
\item \emph{max} -
\item \emph{q1} -
\item \emph{q3} -
\item \emph{n} -
\item \emph{missing} -
\item \emph{df} -
\item \emph{mean_SE} -
\item \emph{median_SE} -
}
\item \strong{raw_data}
\itemize{
\item \emph{grouping_variable} -
\item \emph{outcome_variable} -
\item \emph{grouping_variable_A} -
\item \emph{grouping_variable_B} -
}
}
}
\description{
Returns object
\code{estimate_mdiff_2x2_between} is suitable for a 2x2 between-subjects design
with a continuous outcome variable.  It estimates each main effect, the
simple effects for the first factor, and the interaction.  It can express
these estimates as mean differences, standardized mean differences (Cohen's
d), and as median differences (raw data only).  You can pass raw data or
or summary data (summary data does not return medians).
}
\details{
Reach for this function in place of a 2x2 between-subjects ANOVA.

Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_mdiff]{plot_mdiff()}} and you can visualize the interaction
specifically with \code{\link[=plot_interaction]{plot_interaction()}}.  You can test hypotheses
with \code{\link[=test_mdiff]{test_mdiff()}}.

The estimated mean differences are from \code{\link[statpsych:ci.2x2.mean.bs]{statpsych::ci.2x2.mean.bs()}}.

The estimated SMDs are from \code{\link[statpsych:ci.2x2.stdmean.bs]{statpsych::ci.2x2.stdmean.bs()}}.

The estimated median differences are from \code{\link[statpsych:ci.2x2.median.bs]{statpsych::ci.2x2.median.bs()}}
}
\examples{
data("data_videogameaggression")

estimates_from_raw <- esci::estimate_mdiff_2x2_between(
  esci::data_videogameaggression,
  Agression,
  Violence,
  Difficulty
)

# To visualize the estimated mean difference for the interaction
myplot_from_raw <- esci::plot_mdiff(
  estimates_from_raw$interaction,
  effect_size = "median"
)

# To conduct a hypothesis test on the mean difference
res_htest_from_raw <- esci::test_mdiff(
  estimates_from_raw$interaction,
  effect_size = "median"
)


# From summary data
means <- c(1.5, 1.14, 1.38, 2.22)
sds <- c(1.38, .96,1.5, 1.68)
ns <- c(26, 26, 25, 26)
grouping_variable_A_levels <- c("Evening", "Morning")
grouping_variable_B_levels <- c("Sleep", "No Sleep")

estimates_from_summary <- esci::estimate_mdiff_2x2_between(
  means = means,
  sds = sds,
  ns = ns,
  grouping_variable_A_levels = grouping_variable_A_levels,
  grouping_variable_B_levels = grouping_variable_B_levels,
  grouping_variable_A_name = "Testing Time",
  grouping_variable_B_name = "Rest",
  outcome_variable_name = "False Memory Score",
  assume_equal_variance = TRUE
)

# To visualize the estimated mean difference for the interaction
plot_mdiff_interaction <- esci::plot_mdiff(
  estimates_from_summary$interaction,
  effect_size = "mean"
)

# To visualize the interaction as a line plot
plot_interaction_line <- esci::plot_interaction(estimates_from_summary)

# Same but with fan effect representing each simple-effect CI
plot_interaction_line_CI <- esci::plot_interaction(
  estimates_from_summary,
  show_CI = TRUE
)

# To conduct a hypothesis test on the mean difference
res_htest_from_raw <- esci::test_mdiff(
  estimates_from_summary$interaction,
  effect_size = "mean"
)


}
