% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_srctodest_add.R
\name{ref.srctodest.add}
\alias{ref.srctodest.add}
\title{Linking two existing frames of reference in T.MAT}
\usage{
ref.srctodest.add(src.ref, dest.ref, TM = diag(4), T.MAT = NULL)
}
\arguments{
\item{src.ref}{Character string, pseudonym of the source frame of reference.}

\item{dest.ref}{Character string, pseudonym of the destination frame of reference.}

\item{TM}{4x4 tansfert matrix for moving from \code{src.ref} to {dest.ref}.}

\item{T.MAT}{"t.mat" class object created by
\link[espadon]{load.patient.from.dicom}, \link[espadon]{load.patient.from.Rdcm}
or \link[espadon]{load.T.MAT}. If \code{T.MAT = NULL}, then only the link
between \code{src.ref} and \code{dest.ref} is established.}
}
\value{
Returns a "t.mat" class object, which contains the transfer
matrices from or to \code{dest.ref} pseudonym of the new frame
of reference. If the \code{T.MAT} is \code{NULL}, then the returned object
will contain only 4 matrices: "src.ref<-src.ref",
"src.ref<-dest.ref", "dest.ref<- dest.ref", "dest.ref<-src.ref".
}
\description{
The \code{ref.srctodest.add} function links the source frame of
reference with the destination frame of reference.
}
\examples{
local.Tmat <-  ref.srctodest.add ("ref1","ref2", 
                                  TM = matrix(c (0.5, -sin (pi / 3), 0, 0,
                                                 sin (pi / 3), 0.5, 0, 0,
                                                 0, 0, 1, 0, 0, 0, 0, 1),
                                              ncol = 4))
str (local.Tmat)   
}
\seealso{
\link[espadon]{ref.add}, \link[espadon]{ref.cutplane.add},
\link[espadon]{ref.remove}.
}
