% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esquisser.R
\name{esquisser}
\alias{esquisser}
\title{An add-in to easily create plots with ggplot2}
\usage{
esquisser(
  data = NULL,
  controls = c("labs", "parameters", "appearance", "filters", "code"),
  viewer = getOption(x = "esquisse.viewer", default = "dialog")
)
}
\arguments{
\item{data}{a \code{data.frame}, you can pass a \code{data.frame} explicitly to the function,
otherwise you'll have to choose one in global environment.}

\item{controls}{Controls menu to be displayed. Use \code{NULL} to hide all menus.}

\item{viewer}{Where to display the gadget: \code{"dialog"},
\code{"pane"} or \code{"browser"} (see \code{\link[shiny]{viewer}}).}
}
\value{
\code{NULL}. You can view code used to produce the chart, copy it or insert it in current script.
}
\description{
Select data to be used and map variables to aesthetics to produce a chart,
customize common elements and get code to reproduce the chart.
}
\examples{
if (interactive()) {
# Launch with :
esquisser(iris)
# If in RStudio it will be launched by default in dialog window
# If not, it will be launched in browser

# Launch esquisse in browser :
esquisser(iris, viewer = "browser")

# You can set this option in .Rprofile :
options("esquisse.viewer" = "viewer")
# or
options("esquisse.viewer" = "browser")

# esquisse use shiny::runApp
# see ?shiny::runApp to see options
# available, example to use custom port:

options("shiny.port" = 8080)
esquisser(iris, viewer = "browser")

}
}
