% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Dirichlet.R
\name{ddirich}
\alias{ddirich}
\alias{rdirich}
\title{The Dirichlet Distribution}
\usage{
ddirich(x, shape, log = FALSE)

rdirich(n, shape)
}
\arguments{
\item{x}{numeric. The quantile vector.}

\item{shape}{numeric. The parameter vector.}

\item{log}{logical. If \code{TRUE}, probabilities \code{p} are given as \code{log(p)}.}

\item{n}{numeric. The number of observations.}
}
\value{
\code{ddirich} returns a numeric vector (the evaluated density
function). \code{rdirich} returns a matrix with \code{length(shape)} rows and \code{n}
columns.
}
\description{
Density function and random generation for the Dirichlet distribution with
parameter vector \code{shape}.
}
\examples{
# Classic R Stats Format
ddirich(c(0.3, 0.7), shape = c(2, 3))
set.seed(1)
rdirich(10, shape = c(2, 3))

# S4 Distribution Class
library(distr)
D <- Dirichlet(shape = c(2, 3))
d(D)(c(0.3, 0.7))
set.seed(1)
r(D)(10)
}
