% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_starprep.R
\name{starprep}
\alias{starprep}
\title{Prepare model fits for stargazer}
\usage{
starprep(..., stat = c("std.error", "p.value", "ci", "df"), se_type = NULL,
  clusters = NULL, alpha = 0.05)
}
\arguments{
\item{...}{a list of lm_robust or lm objects}

\item{stat}{either "std.error" (the default), "p.value", "ci", or "df"}

\item{se_type}{(optional) if any of the objects are lm objects, what standard
errors should be used. Must only be one type and will be used for all lm
objects passed to starprep. See `commarobust` for more.}

\item{clusters}{(optional) if any of the objects are lm objects, what clusters
should be used, if clusters should be used. Must only be one vector and will
be used for all lm objects passed to starprep. See `commarobust` for more.}

\item{alpha}{(optional) if any of the objects are lm objects, what significance level
should be used for the p-values or confidence intervals}
}
\value{
a list of vectors of extracted statistics for stargazers
}
\description{
Prepare model fits for stargazer
}
\details{
Used to help extract statistics from lists of model fits for stargazer.
Prefers lm_robust objects, but because `stargazer` does not work with `lm_robust`
objects, `starprep` can also take `lm` objects and calls `commarobust` to get
the preferred, robust statistics.
}
